<?php

namespace App\Exports;

use App\Models\SpdRincian;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class SpdRekapExport implements FromCollection, WithHeadings, WithMapping
{
    protected int $no = 1;

    public function collection(): Collection
    {
        return SpdRincian::with(['pelatihan'])
            ->latest()
            ->get();
    }

    public function headings(): array
    {
        return [
            'No',
            'Nama PTK',
            'NIP',
            'Jenis PTK',
            'Pelatihan',
            'Tahun Anggaran',
            'Nomor SPD',
            'Tanggal SPD',
            'Total SPD',
            'Beban MAK',
            'Bukti Kas No',
            'Jumlah Item',
        ];
    }

    public function map($spd): array
    {
        return [
            $this->no++,
            $spd->nama_ptk ?? '-',
            $spd->nip_ptk ?? '-',
            $this->getJenisPtk($spd->ptk_type),
            $spd->pelatihan->nama_pelatihan ?? '-',
            $spd->tahun_anggaran ?? '-',
            $spd->nomor_spd ?? '-',
            $spd->tanggal_spd
                ? $spd->tanggal_spd->format('d-m-Y')
                : '-',
            $spd->total ?? 0,
            $spd->beban_mak ?? '-',
            $spd->bukti_kas_no ?? '-',
            is_array($spd->items) ? count($spd->items) : 0,
        ];
    }

    protected function getJenisPtk(?string $ptkType): string
    {
        return match ($ptkType) {
            'App\Models\Guru' => 'Guru',
            'App\Models\Pegawai' => 'Pegawai',
            default => '-',
        };
    }
}
