<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DaftarHadirDetail extends Model
{
    protected $table = 'daftar_hadir_detail';

    protected $fillable = [
        'daftar_hadir_id',
        'tipe',
        'pegawai_id',
        'nama_manual',
        'jabatan_manual',
        'instansi_manual',
        'jam_hadir',
    ];
    
    public function isPeserta()
    {
        return $this->tipe === 'peserta';
    }
    
    public function isNarasumber()
    {
        return $this->tipe === 'narasumber';
    }
    
    public function nama()
    {
        return $this->pegawai->nama ?? $this->nama_manual;
    }    

    public function pegawai()
    {
        return $this->belongsTo(Pegawai::class);
    }

    public function daftarHadir()
    {
        return $this->belongsTo(DaftarHadir::class);
    }
}