<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Kuitansi extends Model
{
    protected $table = 'keuangan_kuitansi';

    protected $fillable = [
        'ptk_type',
        'ptk_id',
        'pelatihan_id',
        'tahun_anggaran',
        'bukti_kas_no',
        'beban',
        'akun',
        'sudah_terima_dari',
        'untuk_pembayaran',

        // Honor
        'honor_jp',
        'transport_nominal',
        'transport_kali',
        'transport_total',
        'honor_bruto',

        // Pajak
        'pph21_rate',
        'pph21_amount',
        'jumlah_diterima',

        'tanggal_kuitansi',
        'terbilang',
        'created_by',
    ];

    protected $casts = [
        'tanggal_kuitansi' => 'date',
    ];

    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }

    public function pelatihan()
    {
        return $this->belongsTo(Pelatihan::class);
    }

    public function ptk()
    {
        return $this->morphTo();
    }
}
