<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Pelatihan extends Model
{
    use HasFactory;

    protected $table = 'pelatihan';

    protected $fillable = [
        'nama_pelatihan',
        'kategori',
        'tanggal_mulai',
        'tanggal_selesai',
        'status',
        'penyelenggara',
        'deskripsi',
    ];

    protected $casts = [
        'tanggal_mulai'   => 'date',
        'tanggal_selesai' => 'date',
    ];

    public function peserta()
    {
        return $this->hasMany(PelatihanPeserta::class);
    }

    public function kelas()
    {
        return $this->hasMany(PelatihanKelas::class, 'pelatihan_id');
    }
}
