<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PelatihanKelas extends Model
{
    use HasFactory;

    protected $table = 'pelatihan_kelas';

    protected $fillable = [
        'pelatihan_id',
        'kode_kelas',
        'nama_kelas',
        'admin_lms_user_id',
        'fasil_user_id',
    ];

    public function pelatihan()
    {
        return $this->belongsTo(Pelatihan::class);
    }

    public function adminLms()
    {
        return $this->belongsTo(User::class, 'admin_lms_user_id');
    }

    public function fasil()
    {
        return $this->belongsTo(User::class, 'fasil_user_id');
    }

    public function peserta()
    {
        return $this->hasMany(PelatihanPeserta::class, 'pelatihan_kelas_id');
    }

    public function jadwal()
    {
        return $this->hasMany(\App\Models\PelatihanKelasJadwal::class, 'pelatihan_kelas_id');
    }

    public function kegiatan()
    {
        return $this->hasMany(Kegiatan::class, 'pelatihan_kelas_id');
    }

    public function kelas()
    {
        return $this->hasMany(\App\Models\PelatihanKelas::class, 'pelatihan_id');
    }

    public function fasilManual()
    {
        return $this->hasMany(PelatihanKelasFasil::class, 'pelatihan_kelas_id');
    }
}
