<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\PelatihanKelasAbsensiFasil;

class PelatihanKelasJadwal extends Model
{
    protected $table = 'pelatihan_kelas_jadwal';

    protected $fillable = [
        'pelatihan_kelas_id',
        'tanggal',
        'jam_mulai',
        'jam_selesai',
        'mapel',
        'materi',
        'tempat',
        'ishoma_mulai',
        'ishoma_selesai',
        'fasil_user_id',
    ];

    public function kelas()
    {
        return $this->belongsTo(PelatihanKelas::class, 'pelatihan_kelas_id');
    }

    public function absensiFasil()
    {
        return $this->hasMany(PelatihanKelasAbsensiFasil::class, 'kelas_jadwal_id');
    }
}
