<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PelatihanPeserta extends Model
{
    use HasFactory;

    protected $table = 'pelatihan_peserta';

    protected $fillable = [
        'pelatihan_id',
        'guru_id',
        'pelatihan_kelas_id',
        'registrasi_peserta_id',
        'status_keikutsertaan',
        'nilai',
        'nomor_sertifikat',
        'sertifikat_path',
        'tanggal_selesai',
    ];

    public function pelatihan()
    {
        return $this->belongsTo(Pelatihan::class);
    }

    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }

    public function kelas()
    {
        return $this->belongsTo(PelatihanKelas::class, 'pelatihan_kelas_id');
    }

    public function registrasi()
    {
        return $this->belongsTo(RegistrasiPeserta::class, 'registrasi_peserta_id');
    }
}
