<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SkAnggota extends Model
{
    protected $table = 'sk_anggota';

    protected $fillable = [
        'sk_kegiatan_id',
        'pegawai_id',
        'instansi',
        'keterangan',
    ];

    public function pegawai()
    {
        return $this->belongsTo(Pegawai::class);
    }

    public function sk()
    {
        return $this->belongsTo(SkKegiatan::class, 'sk_kegiatan_id');
    }
}
