<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SkKegiatan extends Model
{
    protected $table = 'sk_kegiatan';

    protected $fillable = [
        'nama_kegiatan',
        'nomor_sk',
        'tanggal_sk',
        'pejabat_penandatangan',
        'nip_penandatangan',
        'jabatan_penandatangan',
    ];

    public function anggota()
    {
        return $this->hasMany(SkAnggota::class);
    }

    public function kegiatan()
    {
        return $this->belongsTo(Kegiatan::class, 'kegiatan_id');
    }
}
