<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
       // NOTE:
        // Migration ini duplikat (ada versi yang lebih baru). Kita bikin jadi aman
        // supaya tidak error urutan FK (pelatihan belum ada) dan tidak bikin double table.

        if (Schema::hasTable('pelatihan_peserta')) {
            return;
        }

        if (!Schema::hasTable('pelatihan') || !Schema::hasTable('guru')) {
            // pelatihan/guru belum dibuat (urutan migrasi), jadi skip.
            return;
        }

        Schema::create('pelatihan_peserta', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pelatihan_id')->constrained('pelatihan')->cascadeOnDelete();
            $table->foreignId('guru_id')->constrained('guru')->cascadeOnDelete();

            $table->enum('status_keikutsertaan', ['terdaftar', 'hadir', 'lulus', 'tidak_lulus'])->default('terdaftar');
            $table->string('nomor_sertifikat')->nullable();
            $table->decimal('nilai', 5, 2)->nullable();
            $table->string('sertifikat_path')->nullable();
            $table->date('tanggal_selesai')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pelatihan_peserta');
    }
};
