<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('guru', function (Blueprint $table) {
            if (!Schema::hasColumn('guru', 'jenis_kelamin')) $table->string('jenis_kelamin', 20)->nullable();
            if (!Schema::hasColumn('guru', 'jabatan')) $table->string('jabatan')->nullable();
            if (!Schema::hasColumn('guru', 'tempat_lahir')) $table->string('tempat_lahir')->nullable();
            if (!Schema::hasColumn('guru', 'nama_bank')) $table->string('nama_bank', 50)->nullable();

            // opsional (kalau belum ada di tabel guru kamu)
            if (!Schema::hasColumn('guru', 'kode_pos')) $table->string('kode_pos', 10)->nullable();
            if (!Schema::hasColumn('guru', 'kabupaten_kota')) $table->string('kabupaten_kota')->nullable();
            if (!Schema::hasColumn('guru', 'provinsi')) $table->string('provinsi')->nullable();
            if (!Schema::hasColumn('guru', 'telp_instansi')) $table->string('telp_instansi', 50)->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('guru', function (Blueprint $table) {
            foreach (['jenis_kelamin','jabatan','tempat_lahir','nama_bank','kode_pos','kabupaten_kota','provinsi','telp_instansi'] as $c) {
                if (Schema::hasColumn('guru', $c)) $table->dropColumn($c);
            }
        });
    }
};
