<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('registrasi_peserta', function (Blueprint $table) {
            $table->id();

            $table->foreignId('pelatihan_id')
                ->constrained('pelatihan')
                ->cascadeOnDelete();

            // optional: relasi ke users (kalau user login)
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            // optional: kalau mau link ke tabel guru
            $table->foreignId('guru_id')
                ->nullable()
                ->constrained('guru')
                ->nullOnDelete();

            $table->string('nama_kegiatan');

            // DATA DIRI
            $table->string('nama');
            $table->string('nik', 50);
            $table->string('nip', 50)->nullable();
            $table->string('jabatan', 150)->nullable();
            $table->string('pangkat_golongan', 150)->nullable();
            $table->string('agama', 50);
            $table->string('jenis_kelamin', 20);
            $table->string('tempat_lahir', 150)->nullable();
            $table->date('tanggal_lahir')->nullable();

            $table->string('no_hp', 30);
            $table->string('email_pribadi')->nullable();

            $table->string('pendidikan_terakhir', 100)->nullable();
            $table->string('prodi', 150)->nullable();

            // UNIT KERJA
            $table->string('unit_kerja');
            $table->text('alamat_unit_kerja');
            $table->string('kab_kota_unit', 100);
            $table->string('provinsi_unit', 100)->default('DKI Jakarta');
            $table->string('kode_pos_unit', 10);
            $table->string('telp_instansi', 30);

            // ALAMAT RUMAH
            $table->text('alamat_rumah');
            $table->string('kab_kota_rumah', 100);
            $table->string('provinsi_rumah', 100)->default('DKI Jakarta');
            $table->string('kode_pos_rumah', 10);

            // NPWP & BANK
            $table->string('npwp', 50);
            $table->string('bank', 100);
            $table->string('no_rekening', 50);

            $table->timestamps();

            // ✅ anti duplikat: nik yang sama tidak bisa daftar di pelatihan yang sama
            $table->unique(['pelatihan_id', 'nik'], 'uniq_reg_pel_nik');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('registrasi_peserta');
    }
};
