<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('keuangan_spd_rincian', function (Blueprint $table) {
            $table->id();

            $table->foreignId('guru_id')->constrained('guru')->cascadeOnDelete();
            $table->foreignId('pelatihan_id')->nullable()->constrained('pelatihan')->nullOnDelete();

            // ✅ link ke registrasi (buat autofill dari form)
            $table->foreignId('registrasi_peserta_id')
                ->nullable()
                ->constrained('registrasi_peserta')
                ->nullOnDelete();

            $table->string('tahun_anggaran', 4);
            $table->string('bukti_kas_no', 100)->nullable();
            $table->string('beban_mak', 150)->nullable();

            $table->string('lampiran_spd', 100)->nullable();
            $table->string('nomor_spd', 100)->nullable();
            $table->date('tanggal_spd')->nullable();

            // rincian item SPD (json)
            $table->json('items')->nullable();
            $table->unsignedBigInteger('total')->default(0);

            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('keuangan_spd_rincian');
    }
};
