<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        // 1) Isi user_id utk data lama (mapping by email_pribadi -> users.email)
        DB::statement("
            UPDATE registrasi_peserta rp
            JOIN users u ON u.email = rp.email_pribadi
            SET rp.user_id = u.id
            WHERE rp.user_id IS NULL
        ");

        // 2) Kalau masih null, isi default (opsional) -> ubah 1 sesuai admin kamu
        DB::statement("
            UPDATE registrasi_peserta
            SET user_id = 1
            WHERE user_id IS NULL
        ");

        Schema::table('registrasi_peserta', function (Blueprint $table) {
            // pastikan kolomnya ada
            if (!Schema::hasColumn('registrasi_peserta', 'user_id')) {
                $table->unsignedBigInteger('user_id')->nullable()->after('pelatihan_id');
            }
        });

        Schema::table('registrasi_peserta', function (Blueprint $table) {
            // UNIQUE biar user yang sama gak bisa daftar pelatihan yg sama 2x
            $table->unique(['user_id', 'pelatihan_id'], 'uniq_reg_user_pel');

            // FK
            $table->foreign('user_id', 'fk_reg_user')
                ->references('id')
                ->on('users')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('registrasi_peserta', function (Blueprint $table) {
            try { $table->dropForeign('fk_reg_user'); } catch (\Throwable $e) {}
            try { $table->dropUnique('uniq_reg_user_pel'); } catch (\Throwable $e) {}
        });
    }
};
