<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pelatihan_kelas_jadwal', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pelatihan_kelas_id')->constrained('pelatihan_kelas')->cascadeOnDelete();

            $table->date('tanggal');
            $table->time('jam_mulai');
            $table->time('jam_selesai');
            $table->string('mapel', 150);
            $table->text('materi')->nullable();

            // kalau fasil di jadwal berbeda dari fasil kelas, bisa override di sini
            $table->foreignId('fasil_user_id')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();

            $table->index(['pelatihan_kelas_id', 'tanggal']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pelatihan_kelas_jadwal');
    }
};
