<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pelatihan_kelas_absensi_fasil', function (Blueprint $table) {
            $table->id();
            $table->foreignId('jadwal_id')->constrained('pelatihan_kelas_jadwal')->cascadeOnDelete();
            $table->foreignId('fasil_user_id')->constrained('users')->cascadeOnDelete();

            $table->enum('status', ['hadir', 'izin', 'sakit', 'alpa'])->default('hadir');
            $table->unsignedInteger('jam_ajar_menit')->nullable();
            $table->string('catatan')->nullable();

            $table->timestamps();

            $table->unique(['jadwal_id', 'fasil_user_id'], 'uq_abs_fasil_jadwal_fasil');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pelatihan_kelas_absensi_fasil');
    }
};
