<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('pelatihan_peserta', function (Blueprint $table) {
            if (!Schema::hasColumn('pelatihan_peserta', 'pelatihan_kelas_id')) {
                $table->foreignId('pelatihan_kelas_id')
                    ->nullable()
                    ->after('pelatihan_id')
                    ->constrained('pelatihan_kelas')
                    ->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::table('pelatihan_peserta', function (Blueprint $table) {
            if (Schema::hasColumn('pelatihan_peserta', 'pelatihan_kelas_id')) {
                $table->dropConstrainedForeignId('pelatihan_kelas_id');
            }
        });
    }
};
