<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pelatihan_peserta', function (Blueprint $table) {
            $table->foreignId('registrasi_peserta_id')
                ->nullable()
                ->after('pelatihan_id')
                ->constrained('registrasi_peserta')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pelatihan_peserta', function (Blueprint $table) {
            $table->dropForeign(['registrasi_peserta_id']);
            $table->dropColumn('registrasi_peserta_id');
        });
    }
};
