<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('sk_kegiatan', function (Blueprint $table) {
            $table->id();
            $table->string('nama_kegiatan');
            $table->foreignId('kegiatan_id')
                  ->constrained('kegiatan')
                  ->cascadeOnDelete();
        
            $table->string('nomor_sk');
            $table->date('tanggal_sk');
            $table->string('pejabat_penandatangan');
            $table->string('nip_penandatangan')->nullable();
            $table->string('jabatan_penandatangan');
            $table->timestamps();
        });        
    }

    public function down(): void
    {
        Schema::dropIfExists('sk_kegiatan');
    }
};
