<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('daftar_hadir_detail', function (Blueprint $table) {
            $table->id();
        
            $table->foreignId('daftar_hadir_id')
                ->constrained('daftar_hadir')
                ->cascadeOnDelete();
        
            $table->foreignId('pegawai_id')
                ->constrained('pegawais')
                ->cascadeOnDelete();
        
            $table->time('jam_hadir')->nullable();
            $table->timestamps();
        });        
    }

    public function down(): void
    {
        Schema::dropIfExists('daftar_hadir_detail');
    }
};
