<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('keuangan_kuitansi', function (Blueprint $table) {
            if (!Schema::hasColumn('keuangan_kuitansi', 'ptk_type')) {
                $table->string('ptk_type')->after('id');
            }

            if (!Schema::hasColumn('keuangan_kuitansi', 'ptk_id')) {
                $table->unsignedBigInteger('ptk_id')->after('ptk_type');
            }
        });
    }

    public function down(): void
    {
        Schema::table('keuangan_kuitansi', function (Blueprint $table) {
            if (Schema::hasColumn('keuangan_kuitansi', 'ptk_type')) {
                $table->dropColumn('ptk_type');
            }

            if (Schema::hasColumn('keuangan_kuitansi', 'ptk_id')) {
                $table->dropColumn('ptk_id');
            }
        });
    }
};
