<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('surat_tugas', function (Blueprint $table) {
            if (!Schema::hasColumn('surat_tugas', 'pejabat_penandatangan')) {
                $table->string('pejabat_penandatangan')->after('tanggal_surat');
            }
    
            if (!Schema::hasColumn('surat_tugas', 'nip_penandatangan')) {
                $table->string('nip_penandatangan')->nullable()->after('pejabat_penandatangan');
            }
    
            if (!Schema::hasColumn('surat_tugas', 'jabatan_penandatangan')) {
                $table->string('jabatan_penandatangan')->after('nip_penandatangan');
            }
        });
    }
    
};
