<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;

class RolesTableSeeder extends Seeder
{
    public function run(): void
    {
        $roles = [
            ['name' => 'super_admin', 'label' => 'Super Admin BGTK'],
            ['name' => 'admin_program', 'label' => 'Admin Program / Pelatihan'],
            ['name' => 'admin_bidang', 'label' => 'Admin Bidang / Operator Data'],
            ['name' => 'pimpinan', 'label' => 'Pimpinan / Kepala BGTK'],
            ['name' => 'peserta', 'label' => 'Guru / Peserta Pelatihan'],
        ];

        foreach ($roles as $role) {
            Role::firstOrCreate(['name' => $role['name']], $role);
        }
    }
}
