@extends('layouts.admin')

@section('title', 'Edit Guru - BGTK DKI')
@section('page_title', 'Edit Data Guru / PTK')
@section('page_subtitle', 'Perbarui data guru sesuai kebutuhan BGTK DKI Jakarta')

@section('content')
    <div class="container-fluid">

        {{-- Tombol Kembali --}}
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h6 class="mb-0 text-muted">Form Edit Data Guru</h6>
            <a href="{{ route('guru.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-body p-4">

                <form action="{{ route('guru.update', $guru->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    {{-- FOTO PROFIL --}}
                    <div class="text-center mb-4">
                        <img src="{{ $guru->foto ? asset('storage/' . $guru->foto) : asset('images/default-profile.png') }}"
                            class="rounded shadow-sm mb-3" style="width: 160px; height: 200px; object-fit: cover;"
                            id="previewFoto">

                        <div class="mx-auto" style="max-width: 260px;">
                            <label class="form-label small text-muted mb-1">Ganti Foto (Opsional)</label>
                            <input type="file" name="foto" class="form-control form-control-sm" accept="image/*"
                                onchange="previewImage(this)">
                            <small class="text-muted d-block mt-1">JPG / PNG • Maks 2MB</small>
                        </div>
                    </div>

                    <hr class="my-4">

                    {{-- DATA UTAMA --}}
                    <div class="row g-3">

                        <div class="col-md-6">
                            <label class="form-label small">Nama Guru</label>
                            <input type="text" name="nama_guru" class="form-control form-control-sm" required
                                value="{{ old('nama_guru', $guru->nama_guru) }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small">NIP</label>
                            <input type="text" name="nip" class="form-control form-control-sm"
                                value="{{ old('nip', $guru->nip) }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small">NUPTK</label>
                            <input type="text" name="nuptk" class="form-control form-control-sm"
                                value="{{ old('nuptk', $guru->nuptk) }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small">NIK</label>
                            <input type="text" name="nik" class="form-control form-control-sm"
                                value="{{ old('nik', $guru->nik) }}">
                        </div>

                        <div class="col-md-12">
                            <label class="form-label small">Sekolah</label>
                            <select name="sekolah_id" id="sekolah_id" class="form-select form-select-sm" required>
                                <option value="">Pilih Sekolah</option>
                                @foreach($sekolahList as $s)
                                    @php $sid = $s->getKey(); @endphp
                                    <option value="{{ $sid }}" {{ (string) old('sekolah_id', $guru->sekolah_id) === (string) $sid ? 'selected' : '' }}>
                                        {{ $s->nama }} — {{ $s->kabupaten }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                    </div>

                    <hr class="my-4">

                    {{-- DATA PRIBADI --}}
                    <div class="row g-3">

                        <div class="col-md-6">
                            <label class="form-label small">Tempat Lahir</label>
                            <input type="text" name="tempat_lahir" class="form-control form-control-sm"
                                value="{{ old('tempat_lahir', $guru->tempat_lahir) }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small">Tanggal Lahir</label>
                            <input type="date" name="tanggal_lahir" class="form-control form-control-sm"
                                value="{{ old('tanggal_lahir', $guru->tanggal_lahir) }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small">Agama</label>
                            <select name="agama" class="form-select form-select-sm">
                                <option value="">Pilih Agama</option>
                                @foreach(['Islam', 'Kristen', 'Katholik', 'Hindu', 'Budha', 'Konghucu', 'Lainnya'] as $ag)
                                    <option value="{{ $ag }}" {{ $guru->agama == $ag ? 'selected' : '' }}>
                                        {{ $ag }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small">Email</label>
                            <input type="email" name="email" class="form-control form-control-sm"
                                value="{{ old('email', $guru->email) }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small">Pangkat / Golongan</label>
                            <input type="text" name="pangkat_golongan" class="form-control form-control-sm"
                                value="{{ old('pangkat_golongan', $guru->pangkat_golongan) }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small">No. HP</label>
                            <input type="text" name="no_hp" class="form-control form-control-sm"
                                value="{{ old('no_hp', $guru->no_hp) }}">
                        </div>

                    </div>

                    {{-- ACTION --}}
                    <div class="mt-4 d-flex justify-content-end gap-2">
                        <button type="submit" class="btn btn-primary btn-sm px-4">
                            <i class="bi bi-save"></i> Simpan
                        </button>
                    </div>

                </form>

            </div>
        </div>
    </div>
@endsection


@push('scripts')
    <script>
        function previewImage(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    document.getElementById('previewFoto').src = e.target.result;
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(function () {
            $('#sekolah_id').select2({
                theme: 'bootstrap-5',
                placeholder: "Cari berdasarkan nama / kabupaten",
                width: '100%'
            });
        });
    </script>
@endpush