@extends('layouts.admin')

@section('title', 'Detail Guru')
@section('page_title', 'Biodata Guru')
@section('page_subtitle', 'Informasi lengkap data pribadi dan kepegawaian PTK')

@section('content')

{{-- HEADER --}}
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body d-flex justify-content-between align-items-center">
        <div>
            <h6 class="mb-1">Biodata Guru</h6>
            <small class="text-muted">Detail identitas dan data kepegawaian</small>
        </div>

        <div class="d-flex gap-2">
            <a href="{{ route('guru.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Kembali
            </a>

            <a href="{{ route('guru.edit', $guru->id) }}" class="btn btn-warning btn-sm">
                <i class="bi bi-pencil-square"></i> Edit
            </a>
        </div>
    </div>
</div>

{{-- BIODATA --}}
<div class="card border-0 shadow-sm">
    <div class="card-body p-4">

        <div class="row g-4">

            {{-- FOTO & IDENTITAS SINGKAT --}}
            <div class="col-md-3 text-center">
                <img
                    src="{{ $guru->foto ? asset('storage/' . $guru->foto) : asset('images/default-profile.png') }}"
                    class="rounded shadow-sm mb-3"
                    style="width: 170px; height: 210px; object-fit: cover;"
                >

                <h6 class="fw-semibold mb-0">{{ $guru->nama_guru }}</h6>
                <small class="text-muted d-block mb-2">
                    {{ $guru->jabatan_ptk ?? 'Guru' }}
                </small>

                <span class="badge bg-success">
                    {{ $guru->status_keaktifan ?? '-' }}
                </span>
            </div>

            {{-- DETAIL BIODATA --}}
            <div class="col-md-9">

                {{-- IDENTITAS PRIBADI --}}
                <div class="mb-4">
                    <h6 class="fw-semibold mb-3 border-bottom pb-2">
                        Identitas Pribadi
                    </h6>

                    <div class="table-responsive">
                        <table class="table table-sm table-bordered align-middle small mb-0">
                            <tbody>
                                <tr>
                                    <th width="25%">NIK</th>
                                    <td width="25%">{{ $guru->nik ?? '-' }}</td>
                                    <th width="25%">NIP</th>
                                    <td width="25%">{{ $guru->nip ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>NUPTK</th>
                                    <td>{{ $guru->nuptk ?? '-' }}</td>
                                    <th>Jenis Kelamin</th>
                                    <td>{{ $guru->jenis_kelamin ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Tempat Lahir</th>
                                    <td>{{ $guru->tempat_lahir ?? '-' }}</td>
                                    <th>Tanggal Lahir</th>
                                    <td>
                                        {{ $guru->tanggal_lahir
                                            ? \Carbon\Carbon::parse($guru->tanggal_lahir)->format('d-m-Y')
                                            : '-' }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>Agama</th>
                                    <td>{{ $guru->agama ?? '-' }}</td>
                                    <th>Status Perkawinan</th>
                                    <td>{{ $guru->status_perkawinan ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td colspan="3">{{ $guru->email ?? '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                {{-- DATA KEPEGAWAIAN --}}
                <div>
                    <h6 class="fw-semibold mb-3 border-bottom pb-2">
                        Data Kepegawaian
                    </h6>

                    <div class="table-responsive">
                        <table class="table table-sm table-bordered align-middle small mb-0">
                            <tbody>
                                <tr>
                                    <th width="25%">Status Kepegawaian</th>
                                    <td width="25%">{{ $guru->status_kepegawaian ?? '-' }}</td>
                                    <th width="25%">Jenis PTK</th>
                                    <td width="25%">{{ $guru->jenis_ptk ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Jabatan</th>
                                    <td>{{ $guru->jabatan ?? '-' }}</td>
                                    <th>Jabatan PTK</th>
                                    <td>{{ $guru->jabatan_ptk ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Pangkat / Golongan</th>
                                    <td>{{ $guru->pangkat_golongan ?? '-' }}</td>
                                    <th>TMT Pengangkatan</th>
                                    <td>{{ $guru->tmt_pengangkatan ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Lembaga Pengangkat</th>
                                    <td>{{ $guru->lembaga_pengangkat ?? '-' }}</td>
                                    <th>PTK Induk</th>
                                    <td>{{ $guru->ptk_induk ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Instansi</th>
                                    <td>{{ $guru->instansi ?? '-' }}</td>
                                    <th>Semester</th>
                                    <td>{{ $guru->semester ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>Kab / Kota</th>
                                    <td>{{ $guru->kab_kota ?? '-' }}</td>
                                    <th>Provinsi</th>
                                    <td>{{ $guru->provinsi ?? '-' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>

    </div>
</div>

@endsection
