<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Daftar Hadir</title>

    <style>
        @page {
            size: A4;
            margin: 1.5cm 2cm 2cm 2.5cm;
        }

        body {
            font-family: "Times New Roman", Times, serif;
            font-size: 11pt;
            line-height: 1.6;
            color: #000;
            margin: 0;
            padding: 0;
        }

        /* ===== KOP ===== */
        .header {
            text-align: center;
            margin-bottom: 22px;
        }

        .header img {
            width: 110%;
            margin-left: -5%;
        }

        /* ===== JUDUL ===== */
        .judul {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 22px;
            letter-spacing: 1px;
        }

        /* ===== INFO ===== */
        table.info {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 18px;
        }

        table.info td {
            padding: 2px 0;
            vertical-align: top;
        }

        .label {
            width: 150px;
            font-weight: bold;
        }

        .titik {
            width: 10px;
            font-weight: bold;
        }

        /* ===== TABEL HADIR ===== */
        table.presensi {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
            font-size: 10pt;
        }

        table.presensi th,
        table.presensi td {
            border: 1px solid #000;
            padding: 8px 6px;
            vertical-align: middle;
        }

        table.presensi th {
            text-align: center;
            font-weight: bold;
        }

        .text-center { text-align: center; }
        .text-left { text-align: left; }
        .text-uppercase { text-transform: uppercase; }

        .ttd {
            height: 38px;
        }
    </style>
</head>

<body>

@php
    use Carbon\Carbon;
    Carbon::setLocale('id');

    /* ===== KOP (BASE64) ===== */
    $kopPath = public_path('images/kop_bgtk_terbaru.png');
    $kopSrc = '';

    if (file_exists($kopPath)) {
        $type = pathinfo($kopPath, PATHINFO_EXTENSION);
        $data = base64_encode(file_get_contents($kopPath));
        $kopSrc = "data:image/{$type};base64,{$data}";
    }

    /* ===== PRIORITAS PEJABAT ===== */
    $priorityNames = [
        'Erfan Agus Munif',
        'Dudi Ruhyadi Muharam',
        'Sultan Takdir Ali Sahbana',
        'Endang Kurniawan',
        'Widyatmo',
        'Ahmad Ghozi',
        'Ani Purwati'
    ];

    /* ===== PESERTA SURAT TUGAS ===== */
    $pegawaiDetails = $daftarHadir->detail
        ->where('tipe','peserta')
        ->whereNotNull('pegawai_id')
        ->sortBy(function ($item) use ($priorityNames) {
            foreach ($priorityNames as $index => $nama) {
                if (str_contains($item->pegawai->nama, $nama)) {
                    return $index;
                }
            }
            return 999;
        })
        ->values();

    /* ===== PESERTA MANUAL ===== */
    $manualDetails = $daftarHadir->detail
        ->where('tipe','peserta')
        ->whereNull('pegawai_id')
        ->values();

    /* ===== GABUNG ===== */
    $sortedDetails = $pegawaiDetails->merge($manualDetails);
@endphp

{{-- ===== KOP ===== --}}
<div class="header">
    <img src="{{ $kopSrc }}" alt="Kop Surat">
</div>

{{-- ===== JUDUL ===== --}}
<div class="judul">DAFTAR HADIR</div>

{{-- ===== INFORMASI KEGIATAN ===== --}}
<table class="info">
    <tr>
        <td class="label">Nama Kegiatan</td>
        <td class="titik">:</td>
        <td>{{ $daftarHadir->suratTugas->nama_kegiatan }}</td>
    </tr>
    <tr>
        <td class="label">Hari / Tanggal</td>
        <td class="titik">:</td>
        <td>{{ Carbon::parse($daftarHadir->tanggal)->translatedFormat('l, d F Y') }}</td>
    </tr>
    <tr>
        <td class="label">Tempat</td>
        <td class="titik">:</td>
        <td>{{ $daftarHadir->tempat }}</td>
    </tr>
</table>

{{-- ===== TABEL PRESENSI ===== --}}
<table class="presensi">
    <thead>
        <tr>
            <th width="6%">NO</th>
            <th width="30%">NAMA</th>
            <th width="26%">JABATAN</th>
            <th width="18%">INSTANSI</th>
            <th width="20%">TANDA TANGAN</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($sortedDetails as $i => $row)
        <tr>
            <td class="text-center">{{ $i + 1 }}</td>

            <td>
                {{ $row->pegawai->nama ?? $row->nama_manual }}
            </td>

            <td>
                {{ $row->pegawai->jabatan ?? '-' }}
            </td>

            <td class="text-left text-uppercase">
                {{ $row->pegawai->instansi ?? 'BGTK PROVINSI DKI JAKARTA' }}
            </td>

            <td class="ttd"></td>
        </tr>
        @endforeach
    </tbody>
</table>

</body>
</html>
