<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Surat Keputusan</title>

    <style>
        @page {
            size: A4;
            margin: 2.5cm 2cm 2cm 2.5cm;
        }

        body {
            font-family: "Times New Roman", Times, serif;
            font-size: 11pt;
            line-height: 1.6;
            color: #000;
            margin: 0;
            padding: 0;
        }

        /* ===== KOP (HALAMAN 1 SAJA) ===== */
        .kop {
            text-align: center;
            margin-bottom: 25px;
        }

        .kop img {
            width: 110%;
            margin-left: -5%;
        }

        /* ===== JUDUL ===== */
        .judul-container {
            text-align: center;
            margin-bottom: 20px;
            text-transform: uppercase;
        }

        .judul-sk {
            font-size: 12pt;
            font-weight: bold;
            line-height: 1.4;
        }

        .nomor-sk {
            font-size: 12pt;
            margin-top: 4px;
        }

        /* ===== STRUKTUR ===== */
        table.struktur {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        table.struktur td {
            vertical-align: top;
            padding: 0;
        }

        .label {
            width: 120px;
            font-weight: bold;
        }

        .titik {
            width: 10px;
            font-weight: bold;
        }

        .isi {
            text-align: justify;
        }

        /* ===== MEMUTUSKAN ===== */
        .memutuskan {
            text-align: center;
            font-weight: bold;
            margin: 16px 0;
        }

        /* ===== TABEL ===== */
        table.data {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 10pt;
        }

        table.data th,
        table.data td {
            border: 1px solid #000;
            padding: 6px;
        }

        table.data th {
            text-align: center;
            font-weight: bold;
        }

        /* ===== TTD ===== */
        .ttd {
            float: right;
            width: 300px;
            margin-top: 30px;
        }

        /* ===== CATATAN ===== */
        .catatan-kaki {
            clear: both;
            margin-top: 45px;
            padding-top: 10px;
            border-top: 0.5pt solid #000;
            font-size: 9pt;
            line-height: 1.4;
        }
    </style>
</head>

<body>

    @php
        use Carbon\Carbon;
        Carbon::setLocale('id');

        /* ================= KOP ================= */
        $kopPath = public_path('images/kop_bgtk_terbaru.png');
        $kopSrc = '';

        if (file_exists($kopPath)) {
            $type = pathinfo($kopPath, PATHINFO_EXTENSION);
            $data = base64_encode(file_get_contents($kopPath));
            $kopSrc = "data:image/{$type};base64,{$data}";
        }

        /* ================= DATA LAMPIRAN ================= */
        $priorityNames = [
            'Erfan Agus Munif',
            'Dudi Ruhyadi Muharam',
            'Sultan Takdir Ali Sahbana',
            'Endang Kurniawan',
            'Widyatmo',
            'Ahmad Ghozi',
            'Ani Purwati'
        ];

        $orderedMembers = $sk->anggota
            ->filter(fn($a) => isset($a->pegawai))
            ->sortBy(function ($member) use ($priorityNames) {
                foreach ($priorityNames as $index => $name) {
                    if (str_contains($member->pegawai->nama, $name)) {
                        return $index;
                    }
                }
                return 999;
            })
            ->values();
    @endphp

    {{-- ================= HALAMAN 1 ================= --}}

    <div class="kop">
        <img src="{{ $kopSrc }}" alt="Kop Surat BGTK">
    </div>

    <div class="judul-container">
        <div class="judul-sk">
            KEPUTUSAN KEPALA BALAI GURU DAN TENAGA KEPENDIDIKAN<br>
            PROVINSI DKI JAKARTA
        </div>

        <div class="nomor-sk">
            Nomor: {{ $sk->nomor_sk }}
        </div>

        <div style="margin-top:10px;font-weight:bold;">
            TENTANG<br>
            PENETAPAN PANITIA KEGIATAN {{ strtoupper($sk->nama_kegiatan) }}
        </div>
    </div>

    <table class="struktur">
        <tr>
            <td class="label">MENIMBANG</td>
            <td class="titik">:</td>
            <td class="isi">
                a. bahwa dalam rangka pelaksanaan kegiatan tersebut perlu dibentuk panitia;<br>
                b. bahwa untuk keperluan tersebut perlu ditetapkan dengan Surat Keputusan.
            </td>
        </tr>
        <tr>
            <td class="label">MENGINGAT</td>
            <td class="titik">:</td>
            <td class="isi">
                1. Peraturan perundang-undangan yang berlaku;<br>
                2. Ketentuan lain yang terkait.
            </td>
        </tr>
    </table>

    <div class="memutuskan">MEMUTUSKAN:</div>

    <table class="struktur">
        <tr>
            <td class="label">MENETAPKAN</td>
            <td class="titik">:</td>
            <td></td>
        </tr>
    </table>

    <table class="struktur" style="margin-left:20px;">
        <tr>
            <td class="label">KESATU</td>
            <td class="titik">:</td>
            <td class="isi">
                Menetapkan Panitia Kegiatan sebagaimana tercantum dalam lampiran Surat Keputusan ini.
            </td>
        </tr>
        <tr>
            <td class="label">KEDUA</td>
            <td class="titik">:</td>
            <td class="isi">
                Panitia bertanggung jawab melaksanakan tugas sesuai ketentuan yang berlaku.
            </td>
        </tr>
        <tr>
            <td class="label">KETIGA</td>
            <td class="titik">:</td>
            <td class="isi">
                Keputusan ini mulai berlaku sejak tanggal ditetapkan.
            </td>
        </tr>
    </table>

    <div class="ttd">
        Ditetapkan di Jakarta<br>
        Pada tanggal {{ Carbon::parse($sk->tanggal_sk)->translatedFormat('d F Y') }}<br><br>
        Kepala,<br><br><br><br>
        <strong>{{ $sk->pejabat_penandatangan }}</strong><br>
        NIP. {{ $sk->nip_penandatangan }}
    </div>

    <div class="catatan-kaki">
        1. Dokumen ini ditandatangani secara elektronik dan sah tanpa tanda tangan basah.<br>
        2. Sesuai Undang-Undang Nomor 11 Tahun 2008 tentang Informasi dan Transaksi Elektronik.
    </div>

    {{-- ================= HALAMAN 2 (LAMPIRAN TANPA KOP) ================= --}}
    <div style="page-break-before: always;"></div>

    <div style="font-weight:bold;margin-bottom:8px;">
        LAMPIRAN DAFTAR PANITIA
    </div>

    <table class="data">
        <thead>
            <tr>
                <th width="8%">NO</th>
                <th width="37%">NAMA</th>
                <th width="30%">INSTANSI</th>
                <th width="25%">KETERANGAN</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($orderedMembers as $i => $anggota)
                <tr>
                    <td align="center">{{ $i + 1 }}</td>
                    <td>{{ $anggota->pegawai->nama }}</td>
                    <td>{{ $anggota->pegawai->instansi ?? 'BGTK PROVINSI DKI JAKARTA' }}</td>
                    <td>{{ $anggota->keterangan ?? $anggota->pegawai->jabatan }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

</body>

</html>