<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Surat Tugas</title>

    <style>
        @page {
            size: A4;
            margin: 2.5cm 2cm 2cm 2.5cm;
        }

        body {
            font-family: "Times New Roman", Times, serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #000;
            margin: 0;
            padding: 0;
        }

        /* ===== KOP (HALAMAN 1 SAJA) ===== */
        .kop {
            text-align: center;
            margin-bottom: 20px;
        }

        .kop img {
            width: 110%;
            margin-left: -5%;
        }

        /* ===== JUDUL ===== */
        .judul-container {
            text-align: center;
            margin-bottom: 20px;
        }

        .judul-surat {
            font-size: 12pt;
            font-weight: bold;
            letter-spacing: 1px;
        }

        .nomor-surat {
            font-size: 12pt;
            margin-top: 4px;
        }

        /* ===== ISI ===== */
        .isi-surat {
            text-align: justify;
            margin-bottom: 12px;
        }

        /* ===== TABEL ===== */
        table.data {
            width: 100%;
            border-collapse: collapse;
            margin: 18px 0;
            font-size: 10.5pt;
        }

        table.data th,
        table.data td {
            border: 1px solid #000;
            padding: 6px;
            vertical-align: middle;
        }

        table.data th {
            text-align: center;
            font-weight: bold;
        }

        /* ===== TTD ===== */
        .footer-wrapper {
            margin-top: 35px;
            width: 100%;
        }

        .ttd-box {
            float: right;
            width: 300px;
        }

        /* ===== CATATAN ===== */
        .catatan-kaki {
            clear: both;
            margin-top: 50px;
            padding-top: 10px;
            border-top: 0.5pt solid #000;
            font-size: 9pt;
            line-height: 1.4;
        }
    </style>
</head>

<body>

    @php
        use Carbon\Carbon;
        Carbon::setLocale('id');

        /* ================= KOP ================= */
        $kopPath = public_path('images/kop_bgtk_terbaru.png');
        $kopSrc = '';

        if (file_exists($kopPath)) {
            $type = pathinfo($kopPath, PATHINFO_EXTENSION);
            $data = base64_encode(file_get_contents($kopPath));
            $kopSrc = "data:image/{$type};base64,{$data}";
        }

        /* ================= DATA ANGGOTA ================= */
        $priorityNames = [
            'Erfan Agus Munif',
            'Dudi Ruhyadi Muharam',
            'Sultan Takdir Ali Sahbana',
            'Endang Kurniawan',
            'Widyatmo',
            'Ahmad Ghozi',
            'Ani Purwati'
        ];

        $orderedMembers = $surat->anggota
            ->filter(fn($a) => isset($a->pegawai))
            ->sortBy(function ($anggota) use ($priorityNames) {
                foreach ($priorityNames as $index => $name) {
                    if (str_contains($anggota->pegawai->nama, $name)) {
                        return $index;
                    }
                }
                return 999;
            })
            ->values();
    @endphp

    {{-- ================= HALAMAN 1 ================= --}}

    {{-- ===== KOP ===== --}}
    <div class="kop">
        <img src="{{ $kopSrc }}" alt="Kop Surat BGTK">
    </div>

    {{-- ===== JUDUL ===== --}}
    <div class="judul-container">
        <div class="judul-surat">SURAT TUGAS</div>
        <div class="nomor-surat">Nomor: {{ $surat->nomor_surat }}</div>
    </div>

    {{-- ===== PEMBUKA ===== --}}
    <div class="isi-surat">
        Yang bertanda tangan di bawah ini:
    </div>

    <table style="border:none; margin-bottom:10px;">
        <tr>
            <td style="border:none;" width="90">Nama</td>
            <td style="border:none;" width="10">:</td>
            <td style="border:none;"><strong>{{ $surat->pejabat_penandatangan }}</strong></td>
        </tr>
        <tr>
            <td style="border:none;">Jabatan</td>
            <td style="border:none;">:</td>
            <td style="border:none;"><strong>{{ $surat->jabatan_penandatangan }}</strong></td>
        </tr>
    </table>

    <div class="isi-surat">
        Dengan ini menugaskan kepada:
    </div>

    {{-- ===== TABEL ANGGOTA ===== --}}
    <table class="data">
        <thead>
            <tr>
                <th width="8%">NO</th>
                <th width="37%">NAMA</th>
                <th width="30%">INSTANSI</th>
                <th width="25%">KETERANGAN</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($orderedMembers as $i => $anggota)
                <tr>
                    <td align="center">{{ $i + 1 }}</td>
                    <td>{{ $anggota->pegawai->nama }}</td>
                    <td>{{ $anggota->pegawai->instansi ?? 'BGTK PROVINSI DKI JAKARTA' }}</td>
                    <td>{{ $anggota->pegawai->keterangan_tugas ?? $anggota->pegawai->jabatan }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{-- ===== KETERANGAN KEGIATAN ===== --}}
    <div class="isi-surat">
        Untuk melaksanakan tugas pada kegiatan
        <strong>{{ $surat->nama_kegiatan }}</strong>, yang dilaksanakan pada:
    </div>

    <table style="border:none; margin-left:25px;">
        <tr>
            <td style="border:none;" width="120">Hari / Tanggal</td>
            <td style="border:none;">
                : {{ Carbon::parse($surat->tanggal_mulai)->translatedFormat('l, d F Y') }}
            </td>
        </tr>
        <tr>
            <td style="border:none;">Tempat</td>
            <td style="border:none;">: {{ $surat->tempat }}</td>
        </tr>
    </table>

    <div class="isi-surat" style="margin-top:12px;">
        Surat tugas ini dibuat untuk dilaksanakan dengan penuh tanggung jawab.
    </div>

    {{-- ===== TTD ===== --}}
    <div class="footer-wrapper">
        <div class="ttd-box">
            Jakarta, {{ Carbon::parse($surat->tanggal_surat)->translatedFormat('d F Y') }}<br>
            Kepala,<br><br><br><br>
            <strong>{{ $surat->pejabat_penandatangan }}</strong><br>
            NIP. {{ $surat->nip_penandatangan }}
        </div>
    </div>

    {{-- ===== CATATAN ===== --}}
    <div class="catatan-kaki">
        1. Dokumen ini ditandatangani secara elektronik dan sah tanpa tanda tangan basah.<br>
        2. Sesuai Undang-Undang Nomor 11 Tahun 2008 tentang Informasi dan Transaksi Elektronik.
    </div>

</body>

</html>