@extends('layouts.admin')

@section('page_title','Edit Surat Tugas')

@section('content')
<div class="card">
    <div class="card-body">

        {{-- Error validasi --}}
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('surat-tugas.update', $surat->id) }}" method="POST">
            @csrf
            @method('PUT')

            {{-- Nama Kegiatan --}}
            <div class="mb-3">
                <label class="form-label fw-semibold">Nama Kegiatan</label>
                <input type="text"
                       name="nama_kegiatan"
                       class="form-control"
                       value="{{ old('nama_kegiatan', $surat->nama_kegiatan) }}"
                       required>
            </div>

            {{-- Nomor Surat --}}
            <div class="mb-3">
                <label class="form-label">Nomor Surat Tugas</label>
                <input type="text"
                       name="nomor_surat"
                       class="form-control"
                       value="{{ old('nomor_surat', $surat->nomor_surat) }}"
                       required>
            </div>

            {{-- Tanggal Surat --}}
            <div class="mb-3">
                <label class="form-label">Tanggal Surat</label>
                <input type="date"
                       name="tanggal_surat"
                       class="form-control"
                       value="{{ old('tanggal_surat', $surat->tanggal_surat) }}"
                       required>
            </div>

            {{-- Tempat Kegiatan --}}
            <div class="mb-4">
                <label class="form-label">Tempat Kegiatan</label>
                <input type="text"
                       name="tempat"
                       class="form-control"
                       value="{{ old('tempat', $surat->tempat) }}"
                       placeholder="Contoh: Hotel Mercure Jakarta"
                       required>
            </div>

            <hr>

            {{-- Pejabat Penandatangan --}}
            <div class="mb-3">
                <label class="form-label">Pejabat Penandatangan</label>
                <input type="text"
                       name="pejabat_penandatangan"
                       class="form-control"
                       value="{{ old('pejabat_penandatangan', $surat->pejabat_penandatangan) }}"
                       required>
            </div>

            {{-- NIP Penandatangan --}}
            <div class="mb-3">
                <label class="form-label">NIP Penandatangan</label>
                <input type="text"
                       name="nip_penandatangan"
                       class="form-control"
                       value="{{ old('nip_penandatangan', $surat->nip_penandatangan) }}">
            </div>

            {{-- Jabatan Penandatangan --}}
            <div class="mb-4">
                <label class="form-label">Jabatan Penandatangan</label>
                <input type="text"
                       name="jabatan_penandatangan"
                       class="form-control"
                       value="{{ old('jabatan_penandatangan', $surat->jabatan_penandatangan) }}"
                       required>
            </div>

            <hr>

            {{-- Pegawai --}}
            <div class="mb-3">
                <label class="form-label fw-semibold">Pegawai yang Ditugaskan</label>

                <div class="card">
                    <div class="card-body" style="max-height:350px; overflow-y:auto">

                        @foreach($pegawais as $jabatan => $items)
                            @php
                                $groupClass = \Illuminate\Support\Str::slug($jabatan ?? 'tanpa-jabatan');
                            @endphp

                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <strong>{{ $jabatan ?? 'Tanpa Jabatan' }}</strong>

                                    <div class="form-check">
                                        <input type="checkbox"
                                               class="form-check-input select-all"
                                               data-group="{{ $groupClass }}"
                                               id="select-all-{{ $groupClass }}">
                                        <label class="form-check-label small"
                                               for="select-all-{{ $groupClass }}">
                                            Pilih Semua
                                        </label>
                                    </div>
                                </div>

                                <hr class="my-2">

                                @foreach($items as $pegawai)
                                    <div class="form-check ms-3 mb-1">
                                        <input class="form-check-input pegawai-checkbox {{ $groupClass }}"
                                               type="checkbox"
                                               name="pegawai_ids[]"
                                               value="{{ $pegawai->id }}"
                                               id="pegawai-{{ $pegawai->id }}"
                                               {{ in_array($pegawai->id, $selectedPegawai) ? 'checked' : '' }}>

                                        <label class="form-check-label"
                                               for="pegawai-{{ $pegawai->id }}">
                                            {{ $pegawai->nama }}
                                            <small class="text-muted">
                                                ({{ $pegawai->nip ?? '-' }})
                                            </small>
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                        @endforeach

                    </div>
                </div>
            </div>

            {{-- Tombol --}}
            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    Update Surat Tugas
                </button>
                <a href="{{ route('surat-tugas.index') }}" class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
@endsection

@push('scripts')
<script>
    // Pilih semua per jabatan
    document.querySelectorAll('.select-all').forEach(function (checkbox) {
        checkbox.addEventListener('change', function () {
            const group = this.dataset.group;
            document.querySelectorAll('.' + group).forEach(function (item) {
                item.checked = checkbox.checked;
            });
        });
    });

    // Auto-centang "Pilih Semua" jika semua pegawai terpilih
    document.querySelectorAll('.select-all').forEach(function (selectAll) {
        const group = selectAll.dataset.group;
        const items = document.querySelectorAll('.' + group);
        selectAll.checked = [...items].every(cb => cb.checked);
    });
</script>
@endpush
