@extends('layouts.admin')

@section('content')
<div class="container py-3">
  <div class="card">
    <div class="card-header fw-bold">
      Tambah Jadwal - {{ $kelas->pelatihan->nama_pelatihan }} ({{ $kelas->nama_kelas }})
    </div>

    <div class="card-body">
      @if ($errors->any())
        <div class="alert alert-danger">
          <ul class="mb-0">
            @foreach ($errors->all() as $e) <li>{{ $e }}</li> @endforeach
          </ul>
        </div>
      @endif

      <form method="POST" action="{{ route('admin.kelas.jadwal.store', $kelas->id) }}">
        @csrf

        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Tanggal</label>
            <input type="date" name="tanggal" class="form-control" required value="{{ old('tanggal') }}">
          </div>

          <div class="col-md-4">
            <label class="form-label">Jam Mulai</label>
            <input type="time" name="jam_mulai" class="form-control" required value="{{ old('jam_mulai') }}">
          </div>

          <div class="col-md-4">
            <label class="form-label">Jam Selesai</label>
            <input type="time" name="jam_selesai" class="form-control" required value="{{ old('jam_selesai') }}">
          </div>

          <div class="col-12">
            <label class="form-label">Tempat</label>
            <input type="text" name="tempat" class="form-control" value="{{ old('tempat') }}">
          </div>

          <div class="col-md-6">
            <label class="form-label">Ishoma Mulai (opsional)</label>
            <input type="time" name="ishoma_mulai" class="form-control" value="{{ old('ishoma_mulai') }}">
          </div>

          <div class="col-md-6">
            <label class="form-label">Ishoma Selesai (opsional)</label>
            <input type="time" name="ishoma_selesai" class="form-control" value="{{ old('ishoma_selesai') }}">
          </div>
        </div>

        <div class="d-flex justify-content-end mt-3">
          <a href="{{ route('admin.laporan-kegiatan.index') }}" class="btn btn-light me-2">Batal</a>
          <button class="btn btn-primary">Simpan Jadwal</button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection
