@extends('layouts.admin')

@section('title', 'Detail Kelas - BGTK DKI')
@section('page_title', 'Detail Kelas')
@section('page_subtitle', $kelas->nama_kelas)

@section('breadcrumbs')
<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('pelatihan.index') }}">Pelatihan</a></li>
    <li class="breadcrumb-item"><a href="{{ route('pelatihan.kelola', $kelas->pelatihan) }}">Kelas</a></li>
    <li class="breadcrumb-item active">{{ $kelas->nama_kelas }}</li>
</ol>
@endsection

@section('content')

{{-- HEADER INFO --}}
<div class="mb-3">
    <div class="fw-semibold fs-6">
        {{ $kelas->pelatihan->nama_pelatihan }} — {{ $kelas->nama_kelas }}
    </div>
    <div class="text-muted small">
        {{ $kelas->pelatihan->kategori ?? '-' }} • Status {{ ucfirst($kelas->pelatihan->status) }}
    </div>
</div>

{{-- ACTION BUTTON --}}
<div class="d-flex flex-wrap gap-2 mb-3">
    <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#modalPeserta">
        <i class="bi bi-plus-circle"></i> Tambah Peserta
    </button>
    <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modalAdmin">
        <i class="bi bi-person-badge"></i> Admin
    </button>
    <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#modalFasil">
        <i class="bi bi-person-video3"></i> Fasil
    </button>

    <a href="{{ route('pelatihan.kelola', $kelas->pelatihan) }}" class="btn btn-sm btn-light ms-auto">
        <i class="bi bi-arrow-left"></i> Kembali
    </a>
</div>

{{-- MAIN LAYOUT --}}
<div class="row g-3">

    {{-- FILTER --}}
    <div class="col-lg-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h6 class="mb-3">Filter Data</h6>

                <form method="GET">
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="role" value="all"
                            {{ request('role', 'all') == 'all' ? 'checked' : '' }}>
                        <label class="form-check-label fw-semibold">Semua</label>
                    </div>

                    <hr class="my-2">

                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="role" value="peserta"
                            {{ request('role') == 'peserta' ? 'checked' : '' }}>
                        <label class="form-check-label">Peserta</label>
                    </div>

                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="role" value="admin"
                            {{ request('role') == 'admin' ? 'checked' : '' }}>
                        <label class="form-check-label">Admin</label>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="radio" name="role" value="fasil"
                            {{ request('role') == 'fasil' ? 'checked' : '' }}>
                        <label class="form-check-label">Fasilitator</label>
                    </div>

                    <button class="btn btn-sm btn-outline-primary w-100">
                        Terapkan
                    </button>
                </form>

            </div>
        </div>
    </div>

    {{-- TABLE --}}
    <div class="col-lg-9">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">

                <table class="table table-sm table-hover align-middle mb-0">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th>Nama</th>
                            <th>Peran</th>
                            <th>Unit</th>
                            <th class="text-center" width="80">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="small">

    {{-- DATA PESERTA & ADMIN --}}
    @forelse($data as $row)
    <tr>
        <td>{{ $row->nama }}</td>
        <td>
            @if($row->role === 'peserta')
                <span class="badge bg-secondary-subtle text-secondary">Peserta</span>
            @elseif($row->role === 'admin')
                <span class="badge bg-primary-subtle text-primary">Admin</span>
            @endif
        </td>
        <td>{{ $row->unit ?? '-' }}</td>
        <td class="text-center">
            <form method="POST"
                  action="{{ route('admin.kelas.peserta.remove', [$kelas->id, $row->id]) }}"
                  onsubmit="return confirm('Yakin hapus data ini?')">
                @csrf
                @method('DELETE')
                <button class="btn btn-sm btn-outline-danger">
                    <i class="bi bi-x"></i>
                </button>
            </form>
        </td>
    </tr>
    @empty
    <tr>
        <td colspan="4" class="text-center text-muted py-4">
            Tidak ada data
        </td>
    </tr>
    @endforelse

    {{-- DATA FASIL MANUAL --}}
    @foreach($kelas->fasilManual as $f)
    <tr>
        <td>{{ $f->nama_fasil }}</td>
        <td>
            <span class="badge bg-warning-subtle text-warning">
                Fasil
            </span>
        </td>
        <td>{{ $f->instansi ?? '-' }}</td>
        <td class="text-center">
            <form method="POST"
                  action="{{ route('admin.kelas.fasil.destroy', [$kelas->id, $f->id]) }}"
                  onsubmit="return confirm('Hapus fasilitator ini?')">
                @csrf
                @method('DELETE')
                <button class="btn btn-sm btn-outline-danger">
                    <i class="bi bi-x"></i>
                </button>
            </form>
        </td>
    </tr>
    @endforeach

</tbody>

                </table>

            </div>
        </div>
    </div>

</div>

{{-- MODAL PESERTA --}}
<div class="modal fade" id="modalPeserta">
    <div class="modal-dialog">
        <form method="POST" action="{{ route('admin.kelas.peserta.assign', $kelas) }}" class="modal-content">
            @csrf
            <div class="modal-header">
                <h6 class="modal-title">Tambah Peserta</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <select name="registrasi_peserta_id" class="form-select js-select2" required>
                    <option value="">Pilih Peserta</option>
                    @foreach($pesertaTersedia as $p)
                        <option value="{{ $p->id }}">{{ $p->nama }} — {{ $p->unit_kerja }}</option>
                    @endforeach
                </select>
            </div>
            <div class="modal-footer">
                <button class="btn btn-success btn-sm">Simpan</button>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" id="modalAdmin">
    <div class="modal-dialog">
        <form method="POST"
              action="{{ route('admin.kelas.pengelola.update', $kelas) }}"
              class="modal-content">
            @csrf
            @method('PUT')

            <div class="modal-header">
                <h6 class="modal-title">Pilih Admin Kelas</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <select name="admin_lms_user_id"
                        class="form-select js-select2"
                        required>
                    <option value="">Pilih User</option>
                    @foreach($adminUsers as $u)
                        <option value="{{ $u->id }}"
                            @selected($kelas->admin_lms_user_id == $u->id)>
                            {{ $u->name }} — {{ $u->email }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="modal-footer">
                <button class="btn btn-primary btn-sm">Simpan</button>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" id="modalFasil">
    <div class="modal-dialog modal-lg">
        <form method="POST"
              action="{{ route('admin.kelas.fasil.store', $kelas) }}"
              class="modal-content">
            @csrf

            <div class="modal-header">
                <h6 class="modal-title">Tambah Fasilitator</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body row g-2">

                <div class="col-md-6">
                    <label class="form-label">Nama Fasil</label>
                    <input name="nama_fasil" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">No Telp/WA</label>
                    <input name="no_telp" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Instansi</label>
                    <input name="instansi" class="form-control">
                </div>

                <div class="col-md-4">
                    <label class="form-label">Tanggal</label>
                    <input type="date" name="tanggal" class="form-control" required>
                </div>

                <div class="col-md-4">
                    <label class="form-label">JP</label>
                    <input type="number" name="jp" class="form-control" min="1" required>
                    <small class="text-muted">1 JP = 45 menit</small>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Waktu Mulai</label>
                    <input type="time" name="waktu_mulai" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Waktu Selesai</label>
                    <input type="time" name="waktu_selesai" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Tempat</label>
                    <input name="tempat" class="form-control">
                </div>

                <div class="col-md-6">
                    <label class="form-label">Keterangan</label>
                    <input name="keterangan" class="form-control">
                </div>

            </div>

            <div class="modal-footer">
                <button class="btn btn-warning btn-sm">Simpan</button>
            </div>
        </form>
    </div>
</div>



@endsection

@push('scripts')
<script>
$('.js-select2').select2({
    theme: 'bootstrap-5',
    width: '100%'
});
</script>
@endpush
