@extends('layouts.admin')

@section('title', 'Edit Kuitansi')
@section('page_title', 'Edit Kuitansi')
@section('page_subtitle', 'Perbarui data kuitansi honor/perintah pembayaran')

@section('content')
    @if($errors->any())
        <div class="alert alert-danger small">
            <strong>Terjadi kesalahan:</strong>
            <ul class="mb-0 mt-1">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.keuangan.kuitansi.update', $kuitansi->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body">
                <h6 class="mb-3">Informasi Umum</h6>

                <div class="row g-3 small">
                    <div class="col-md-4">
                        <label class="form-label">PTK / Guru</label>
                        <select name="guru_id" id="guru_id" class="form-select form-select-sm js-guru-select"
                                data-placeholder="Cari PTK / Guru" required>
                            <option value="">-- pilih PTK --</option>

                            @if(isset($selectedGuru) && $selectedGuru)
                                <option value="{{ $selectedGuru->id }}" selected>
                                    {{ $selectedGuru->nama_guru }}
                                    @if($selectedGuru->nip) - ({{ $selectedGuru->nip }}) @endif
                                </option>
                            @endif
                        </select>
                        <small class="text-muted">
                            Ketik nama / NIP / NUPTK untuk mencari PTK.
                        </small>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Pelatihan</label>
                        <select name="pelatihan_id" class="form-select form-select-sm">
                            <option value="">-- opsional --</option>
                            @foreach($pelatihanList as $p)
                                <option value="{{ $p->id }}"
                                    {{ old('pelatihan_id', $kuitansi->pelatihan_id) == $p->id ? 'selected' : '' }}>
                                    {{ $p->nama_pelatihan }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">Tahun Anggaran</label>
                        <input type="text" name="tahun_anggaran"
                               value="{{ old('tahun_anggaran', $kuitansi->tahun_anggaran) }}"
                               class="form-control form-control-sm" required>
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">Tanggal Kuitansi</label>
                        <input type="date" name="tanggal_kuitansi"
                               value="{{ old('tanggal_kuitansi', optional($kuitansi->tanggal_kuitansi)->format('Y-m-d')) }}"
                               class="form-control form-control-sm">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Bukti Kas No.</label>
                        <input type="text" name="bukti_kas_no"
                               value="{{ old('bukti_kas_no', $kuitansi->bukti_kas_no) }}"
                               class="form-control form-control-sm">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Beban</label>
                        <input type="text" name="beban"
                               value="{{ old('beban', $kuitansi->beban) }}"
                               class="form-control form-control-sm">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Akun</label>
                        <input type="text" name="akun"
                               value="{{ old('akun', $kuitansi->akun) }}"
                               class="form-control form-control-sm">
                    </div>

                    <div class="col-md-12">
                        <label class="form-label">Sudah terima dari</label>
                        <input type="text" name="sudah_terima_dari"
                               value="{{ old('sudah_terima_dari', $kuitansi->sudah_terima_dari) }}"
                               class="form-control form-control-sm">
                    </div>

                    <div class="col-md-12">
                        <label class="form-label">Untuk pembayaran</label>
                        <textarea name="untuk_pembayaran" class="form-control form-control-sm" rows="2" required>{{ old('untuk_pembayaran', $kuitansi->untuk_pembayaran) }}</textarea>
                    </div>
                </div>
            </div>
        </div>

        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body small">
                <h6 class="mb-3">Perhitungan Honor</h6>

                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Honor Bruto (Rp)</label>
                        <input type="number" name="honor_bruto" id="honor_bruto"
                               value="{{ old('honor_bruto', $kuitansi->honor_bruto ?? 0) }}"
                               class="form-control form-control-sm" min="0" required>
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">PPH 21 (%)</label>
                        <input type="number" name="pph21_rate"
                               value="{{ old('pph21_rate', $kuitansi->pph21_rate ?? 0) }}"
                               class="form-control form-control-sm" min="0" step="0.01">
                    </div>

                    <div class="col-md-6">
                        <small class="text-muted d-block mt-4">
                            Nilai PPH 21 dan jumlah diterima dihitung ulang oleh sistem saat disimpan.
                        </small>
                    </div>
                </div>

                <hr class="my-3">

                <div class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">Transport / PP (Rp)</label>
                        <input type="number" name="transport_nominal" id="transport_nominal"
                               value="{{ old('transport_nominal', $kuitansi->transport_nominal ?? 0) }}"
                               class="form-control form-control-sm" min="0">
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">Jumlah PP</label>
                        <input type="number" name="transport_kali" id="transport_kali"
                               value="{{ old('transport_kali', $kuitansi->transport_kali ?? 0) }}"
                               class="form-control form-control-sm" min="0">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Total Transport (Rp)</label>
                        <input type="number" id="transport_total"
                               value="{{ ($kuitansi->transport_nominal ?? 0) * ($kuitansi->transport_kali ?? 0) }}"
                               class="form-control form-control-sm" readonly>
                        <small class="text-muted">Otomatis: nominal × jumlah PP</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="{{ route('admin.keuangan.kuitansi.index') }}" class="btn btn-outline-secondary">
                Kembali
            </a>
            <button type="submit" class="btn btn-primary">
                Simpan Perubahan
            </button>
        </div>
    </form>
@endsection

@push('scripts')
<script>
    function hitungTransport() {
        let nominal = parseInt(document.getElementById('transport_nominal').value) || 0;
        let kali = parseInt(document.getElementById('transport_kali').value) || 0;
        document.getElementById('transport_total').value = nominal * kali;
    }

    document.addEventListener('DOMContentLoaded', function () {
        // total transport realtime
        document.getElementById('transport_nominal').addEventListener('input', hitungTransport);
        document.getElementById('transport_kali').addEventListener('input', hitungTransport);

        // select2 guru (kalau kamu sudah punya route guru.select2)
        $('#guru_id').select2({
            theme: 'bootstrap-5',
            placeholder: 'Cari PTK / Guru...',
            allowClear: true,
            ajax: {
                url: "{{ route('guru.select2') }}",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { q: params.term };
                },
                processResults: function (data) {
                    return { results: data.results };
                },
                cache: true
            }
        });
    });
</script>
@endpush
