@extends('layouts.admin')

@section('content')
<div class="container py-3">
  <div class="d-flex flex-wrap justify-content-between align-items-center gap-2 mb-3">
    <div>
      <h4 class="mb-0">Laporan Kegiatan & Daftar Hadir</h4>
      <div class="text-muted small">
        Pilih jadwal kegiatan, lalu unduh dokumen: <b>Laporan</b>, <b>Absensi Peserta</b>, atau <b>Absensi Fasil</b>.
      </div>
    </div>
  </div>

  @forelse($pelatihan as $p)
    <div class="card mb-3 shadow-sm">
      <div class="card-header fw-bold d-flex justify-content-between align-items-center">
        <span>{{ $p->nama_pelatihan }}</span>
        <span class="badge text-bg-light border">
          Kelas: {{ $p->kelas->count() }}
        </span>
      </div>

      <div class="card-body">
        @forelse($p->kelas as $k)
          <div class="border rounded-3 p-3 mb-3">
            <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
              <div>
                <div class="fw-bold">{{ $k->nama_kelas }}</div>
                <div class="text-muted small">
                  Jumlah jadwal: <b>{{ $k->jadwal->count() }}</b>
                </div>
                <a href="{{ route('admin.kelas.jadwal.create', $k->id) }}" class="btn btn-sm btn-primary">
                  + Tambah Jadwal
                </a>
              </div>

              @if($k->jadwal->count() > 0)
                <div class="text-muted small">
                  Klik tombol di kolom <b>Dokumen</b> sesuai kebutuhan.
                </div>
              @endif
            </div>

            <div class="table-responsive mt-3">
              <table class="table table-sm align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th style="width:140px;">Tanggal</th>
                    <th style="width:160px;">Jam</th>
                    <th>Tempat</th>
                    <th class="text-end" style="width:360px;">Dokumen</th>
                  </tr>
                </thead>

                <tbody>
                @forelse($k->jadwal as $j)
                  <tr>
                    <td>
                      {{ \Carbon\Carbon::parse($j->tanggal)->format('d-m-Y') }}
                      <div class="text-muted small">
                        {{ \Carbon\Carbon::parse($j->tanggal)->translatedFormat('l') }}
                      </div>
                    </td>
                    <td>
                      {{ substr($j->jam_mulai,0,5) }} - {{ substr($j->jam_selesai,0,5) }}
                      @if(!empty($j->ishoma_mulai) && !empty($j->ishoma_selesai))
                        <div class="text-muted small">
                          Ishoma: {{ substr($j->ishoma_mulai,0,5) }}-{{ substr($j->ishoma_selesai,0,5) }}
                        </div>
                      @endif
                    </td>
                    <td>{{ $j->tempat ?? '-' }}</td>
                    <td class="text-end">
                      <div class="d-flex justify-content-end flex-wrap gap-2">
                        <a class="btn btn-outline-primary btn-sm"
                           href="{{ route('admin.laporan-kegiatan.downloadLaporan', $j->id) }}">
                          <i class="bi bi-file-earmark-text me-1"></i>Laporan (.doc)
                        </a>

                        <a class="btn btn-outline-success btn-sm"
                           href="{{ route('admin.laporan-kegiatan.downloadDaftarHadirPeserta', $j->id) }}">
                          <i class="bi bi-people me-1"></i>Absensi Peserta
                        </a>

                        <a class="btn btn-outline-dark btn-sm"
                           href="{{ route('admin.laporan-kegiatan.downloadDaftarHadirFasil', $j->id) }}">
                          <i class="bi bi-person-badge me-1"></i>Absensi Fasil
                        </a>
                      </div>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="text-muted text-center py-3">
                      Belum ada jadwal untuk kelas ini.
                    </td>
                  </tr>
                @endforelse
                </tbody>
              </table>
            </div>
          </div>
        @empty
          <div class="text-muted">Belum ada kelas untuk pelatihan ini.</div>
        @endforelse
      </div>
    </div>
  @empty
    <div class="alert alert-light border">
      Belum ada data pelatihan.
    </div>
  @endforelse

</div>
@endsection
