@extends('layouts.admin')

@section('title', 'Data Pegawai BGTK - BGTK DKI')
@section('page_title', 'Data Pegawai BGTK')
@section('page_subtitle', 'Master data pegawai BGTK, informasi kepegawaian')

@section('content')

    {{-- Alert --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show small" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show small" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- ===========================
    CARD FILTER + TOOLBAR
    ============================ --}}
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">

            <div
                class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3 mb-3">
                <div>
                    <h6 class="mb-1">Pencarian & Filter Data Pegawai</h6>
                    <small class="text-muted">
                        Cari berdasarkan nama, NIP, email, jabatan, atau golongan.
                    </small>
                </div>

                {{-- Toolbar Import & Export --}}
                <div class="d-flex gap-2">
                    {{-- Export --}}
                    <a href="{{ route('pegawai.export') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="bi bi-download me-1"></i> Export
                    </a>

                    {{-- Import (modal) --}}
                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal"
                        data-bs-target="#modalImportPegawai">
                        <i class="bi bi-upload me-1"></i> Import
                    </button>
                </div>
            </div>

            {{-- Tambah Data --}}
            <a href="{{ route('pegawai.create') }}" class="btn btn-success btn-sm mb-3">
                <i class="bi bi-plus-lg me-1"></i> Tambah Data
            </a>

            {{-- Form Filter --}}
            <form method="GET" action="{{ route('pegawai.index') }}" class="row g-2 align-items-end">

                <div class="col-12 col-md-4">
                    <label class="form-label small mb-1">Nama / NIP / Email</label>
                    <input type="text" name="search" value="{{ $search ?? '' }}" class="form-control form-control-sm"
                        placeholder="Contoh: NIP, nama, atau email">
                </div>

                <div class="col-12 col-md-3">
                    <label class="form-label small mb-1">Jabatan</label>
                    <input type="text" name="jabatan" value="{{ $jabatan ?? '' }}" class="form-control form-control-sm"
                        placeholder="Filter berdasarkan jabatan">
                </div>

                <div class="col-12 col-md-2 d-flex gap-2">
                    <button type="submit" class="btn btn-dark btn-sm w-100">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>
                    <a href="{{ route('pegawai.index') }}" class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">
                        Reset
                    </a>
                </div>

            </form>
        </div>
    </div>

    {{-- ===========================
    TABLE DATA PEGAWAI
    ============================ --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Daftar Pegawai BGTK</h6>
                @if(method_exists($pegawai, 'total'))
                    <small class="text-muted">
                        Menampilkan {{ $pegawai->total() }} data
                        ({{ $pegawai->firstItem() ?? 0 }} - {{ $pegawai->lastItem() ?? 0 }})
                    </small>
                @endif
            </div>

            <div class="table-responsive mt-2">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th>Nama & NIP</th>
                            <th>Jabatan & Golongan</th>
                            <th>Tanggal Lahir & JK</th>
                            <th>Kontak</th>
                            <th>Status</th>
                            <th class="text-center" style="width: 90px;">Aksi</th>
                        </tr>
                    </thead>

                    <tbody class="small">
                        @forelse($pegawai as $p)
                                        <tr>

                                            {{-- Nama & NIP --}}
                                            <td>
                                                <div class="fw-semibold">{{ $p->nama }}</div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    NIP: {{ $p->nip ?? '-' }}
                                                </div>
                                            </td>

                                            {{-- Jabatan & Gol --}}
                                            <td>
                                                <div>{{ $p->jabatan ?? '-' }}</div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    Gol: {{ $p->gol ?? '-' }} / {{ $p->pangkat_golongan ?? '-' }}
                                                </div>
                                            </td>

                                            {{-- Tanggal Lahir & Jenis Kelamin --}}
                                            <td>
                                                <div>
                                                    {{ $p->tanggal_lahir
                            ? $p->tanggal_lahir->format('d-m-Y')
                            : '-' }}
                                                </div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    {{ $p->jenis_kelamin ?? '-' }}
                                                </div>
                                            </td>

                                            {{-- Kontak --}}
                                            <td>
                                                <div class="text-truncate" style="max-width: 180px;">
                                                    {{ $p->email ?? '-' }}
                                                </div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    {{ $p->telepon ?? '-' }}
                                                </div>
                                            </td>

                                            {{-- Status --}}
                                            <td>
                                                <div>{{ $p->status_kepegawaian ?? '-' }}</div>
                                                <div class="text-muted" style="font-size:11px;">
                                                    {{ $p->instansi ?? '-' }}
                                                </div>
                                            </td>


                                            {{-- Aksi --}}
                                            <td class="text-center">
                                                <div class="dropdown">
                                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                                        data-bs-toggle="dropdown">
                                                        <i class="bi bi-three-dots-vertical"></i>
                                                    </button>

                                                    <ul class="dropdown-menu dropdown-menu-end small shadow">
                                                        <li>
                                                            <a class="dropdown-item" href="{{ route('pegawai.show', $p) }}">
                                                                <i class="bi bi-eye me-2 text-info"></i> Detail
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item" href="{{ route('pegawai.edit', $p) }}">
                                                                <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <hr class="dropdown-divider">
                                                        </li>
                                                        <li>
                                                            <form action="{{ route('pegawai.destroy', $p) }}" method="POST"
                                                                class="form-delete">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="button" class="dropdown-item text-danger btn-delete">
                                                                    <i class="bi bi-trash me-2"></i> Hapus
                                                                </button>
                                                            </form>

                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>

                                        </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">
                                    Belum ada data pegawai
                                </td>
                            </tr>
                        @endforelse
                    </tbody>

                </table>
            </div>

            {{-- PAGINASI --}}
            @if(method_exists($pegawai, 'links'))
                <div
                    class="d-flex flex-column flex-md-row justify-content-between align-items-center mt-3 small text-muted gap-2">
                    <div>
                        Menampilkan {{ $pegawai->firstItem() ?? 0 }} - {{ $pegawai->lastItem() ?? 0 }}
                        dari {{ $pegawai->total() }} data
                    </div>
                    <div>
                        {{ $pegawai->onEachSide(1)->links() }}
                    </div>
                </div>
            @endif
        </div>
    </div>

    {{-- MODAL IMPORT PEGAWAI --}}
    <div class="modal fade" id="modalImportPegawai" tabindex="-1" aria-labelledby="modalImportPegawaiLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form action="{{ route('pegawai.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header">
                        <h6 class="modal-title" id="modalImportPegawaiLabel">Import Data Pegawai</h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <p class="small text-muted mb-2">
                            Gunakan template Excel resmi (Data Pegawai) yang berisi kolom nama, NIP, gol, pangkat, jabatan,
                            email, telepon, alamat, tanggal lahir, dan jenis kelamin.
                        </p>
                        <div class="mb-2">
                            <label class="form-label small">File Excel (.xlsx / .xls)</label>
                            <input type="file" name="file" class="form-control form-control-sm" accept=".xlsx,.xls"
                                required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary btn-sm" data-bs-dismiss="modal">
                            Batal
                        </button>
                        <button type="submit" class="btn btn-primary btn-sm">
                            Import
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <audio id="deleteSound">
        <source src="{{ asset('sounds/warning.mp3') }}" type="audio/mpeg">
    </audio>


@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const deleteButtons = document.querySelectorAll('.btn-delete');
            const sound = document.getElementById('deleteSound');

            function stopSound() {
                sound.pause();
                sound.currentTime = 0;
            }

            deleteButtons.forEach(btn => {
                btn.addEventListener('click', function () {
                    // 🔊 PLAY SOUND
                    stopSound(); // pastikan bersih dulu
                    sound.play();

                    // ⏳ Delay dikit biar kaget
                    setTimeout(() => {
                        const yakin = confirm(
                            "⚠️ PERINGATAN KERAS ⚠️\n\n" +
                            "Data pegawai akan DIHAPUS PERMANEN!\n" +
                            "Tindakan ini TIDAK bisa dibatalkan.\n\n" +
                            "Apakah kamu yakin?"
                        );

                        // 🛑 STOP SOUND SAAT USER PILIH
                        stopSound();

                        if (yakin) {
                            btn.closest('form').submit();
                        }
                    }, 300);
                });
            });
        });
    </script>
@endpush