{{-- resources/views/pelatihan/form.blade.php --}}

@csrf

<div class="row g-3">
    <div class="col-12">
        <label class="form-label small">Nama Pelatihan</label>
        <input type="text"
               name="nama_pelatihan"
               class="form-control form-control-sm @error('nama_pelatihan') is-invalid @enderror"
               value="{{ old('nama_pelatihan', $pelatihan->nama_pelatihan ?? '') }}"
               required>
        @error('nama_pelatihan')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-4 col-12">
        <label class="form-label small">Kategori</label>
        <select name="kategori"
                class="form-select form-select-sm @error('kategori') is-invalid @enderror">
            <option value="">Pilih kategori</option>
            <option value="BK" {{ old('kategori', $pelatihan->kategori ?? '') == 'BK' ? 'selected' : '' }}>BK / Konseling</option>
            <option value="Matematika" {{ old('kategori', $pelatihan->kategori ?? '') == 'Matematika' ? 'selected' : '' }}>Matematika</option>
            <option value="Tendik" {{ old('kategori', $pelatihan->kategori ?? '') == 'Tendik' ? 'selected' : '' }}>Tendik</option>
            <option value="Pembelajaran Mendalam" {{ old('kategori', $pelatihan->kategori ?? '') == 'PembelajaranMendalam' ? 'selected' : '' }}>Pembelajaran Mendalam</option>
        </select>
        @error('kategori')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-4 col-6">
        <label class="form-label small">Tanggal Mulai</label>
        <input type="date"
               name="tanggal_mulai"
               class="form-control form-control-sm @error('tanggal_mulai') is-invalid @enderror"
               value="{{ old('tanggal_mulai', isset($pelatihan->tanggal_mulai) ? $pelatihan->tanggal_mulai->format('Y-m-d') : '') }}">
        @error('tanggal_mulai')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-4 col-6">
        <label class="form-label small">Tanggal Selesai</label>
        <input type="date"
               name="tanggal_selesai"
               class="form-control form-control-sm @error('tanggal_selesai') is-invalid @enderror"
               value="{{ old('tanggal_selesai', isset($pelatihan->tanggal_selesai) ? $pelatihan->tanggal_selesai->format('Y-m-d') : '') }}">
        @error('tanggal_selesai')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-4 col-12">
        <label class="form-label small">Status</label>
        <select name="status"
                class="form-select form-select-sm @error('status') is-invalid @enderror">
            <option value="draft" {{ old('status', $pelatihan->status ?? 'draft') == 'draft' ? 'selected' : '' }}>Draft</option>
            <option value="berjalan" {{ old('status', $pelatihan->status ?? '') == 'berjalan' ? 'selected' : '' }}>Berjalan</option>
            <option value="selesai" {{ old('status', $pelatihan->status ?? '') == 'selesai' ? 'selected' : '' }}>Selesai</option>
        </select>
        @error('status')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-8 col-12">
        <label class="form-label small">Penyelenggara</label>
        <input type="text"
               name="penyelenggara"
               class="form-control form-control-sm @error('penyelenggara') is-invalid @enderror"
               value="{{ old('penyelenggara', $pelatihan->penyelenggara ?? 'BGTK DKI Jakarta') }}">
        @error('penyelenggara')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-12">
        <label class="form-label small">Deskripsi Singkat</label>
        <textarea name="deskripsi"
                  rows="3"
                  class="form-control form-control-sm @error('deskripsi') is-invalid @enderror"
                  placeholder="Tuliskan gambaran umum pelatihan, sasaran peserta, atau tujuan pelaksanaan">{{ old('deskripsi', $pelatihan->deskripsi ?? '') }}</textarea>
        @error('deskripsi')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-12 d-flex justify-content-end gap-2 mt-2">
        <a href="{{ route('pelatihan.index') }}" class="btn btn-outline-secondary btn-sm">
            Batal
        </a>
        <button type="submit" class="btn btn-primary btn-sm">
            Simpan
        </button>
    </div>
</div>
