@extends('layouts.admin')

@section('title', 'Data Pelatihan - BGTK DKI')
@section('page_title', 'Data Pelatihan')
@section('page_subtitle', 'Pengelolaan pelatihan BK, Matematika, Tendik, dan bidang lain')

@section('content')

    {{-- ALERT --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- FILTER & ACTION --}}
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">

            <div class="d-flex flex-column flex-md-row justify-content-between gap-3 mb-3">
                <div>
                    <h6 class="mb-1">Pencarian & Filter Data Pelatihan</h6>
                    <small class="text-muted">
                        Filter berdasarkan nama pelatihan, kategori, dan status.
                    </small>
                </div>

                <div>
                    <a href="{{ route('pelatihan.create') }}" class="btn btn-success btn-sm">
                        <i class="bi bi-plus-lg me-1"></i> Tambah Pelatihan
                    </a>
                </div>
            </div>

            {{-- FORM FILTER --}}
            <form method="GET" action="{{ route('pelatihan.index') }}" class="row g-2">
                <div class="col-12 col-md-4">
                    <label class="form-label form-label-sm mb-1">Nama Pelatihan</label>
                    <input type="text"
                           name="search"
                           value="{{ $search ?? '' }}"
                           class="form-control form-control-sm"
                           placeholder="Cari nama pelatihan">
                </div>

                <div class="col-6 col-md-3">
                    <label class="form-label form-label-sm mb-1">Kategori</label>
                    <select name="kategori" class="form-select form-select-sm">
                        <option value="">Semua kategori</option>
                        @foreach($kategoriList as $k)
                            <option value="{{ $k }}" {{ ($kategori ?? '') === $k ? 'selected' : '' }}>
                                {{ $k }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-6 col-md-3">
                    <label class="form-label form-label-sm mb-1">Status</label>
                    <select name="status" class="form-select form-select-sm">
                        <option value="">Semua status</option>
                        <option value="draft" {{ ($status ?? '') === 'draft' ? 'selected' : '' }}>Draft</option>
                        <option value="berjalan" {{ ($status ?? '') === 'berjalan' ? 'selected' : '' }}>Berjalan</option>
                        <option value="selesai" {{ ($status ?? '') === 'selesai' ? 'selected' : '' }}>Selesai</option>
                    </select>
                </div>

                <div class="col-12 col-md-2 d-flex align-items-end gap-2">
                    <button class="btn btn-dark btn-sm w-100">
                        <i class="bi bi-search me-1"></i> Terapkan
                    </button>
                    <a href="{{ route('pelatihan.index') }}"
                       class="btn btn-outline-secondary btn-sm d-none d-md-inline-flex">
                        Reset
                    </a>
                </div>
            </form>

        </div>
    </div>

    {{-- TABLE --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Daftar Pelatihan</h6>
                <small class="text-muted">
                    Menampilkan {{ $pelatihan->total() }} data
                </small>
            </div>

            <div class="table-responsive">
                <table class="table table-sm table-hover align-middle">
                    <thead class="table-light small text-uppercase">
                        <tr>
                            <th>Nama Pelatihan</th>
                            <th class="text-center">Kategori</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Penyelenggara</th>
                            <th class="text-center">Periode</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="small">
                        @forelse($pelatihan as $p)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ $p->nama_pelatihan }}</div>
                                    @if($p->deskripsi)
                                        <small class="text-muted">
                                            {{ \Illuminate\Support\Str::limit($p->deskripsi, 80) }}
                                        </small>
                                    @endif
                                </td>

                                <td class="text-center">{{ $p->kategori ?? '-' }}</td>

                                <td class="text-center">
                                    <span class="badge bg-{{ 
                                        $p->status === 'draft' ? 'warning' : 
                                        ($p->status === 'berjalan' ? 'success' : 'info') 
                                    }}-subtle text-{{ 
                                        $p->status === 'draft' ? 'warning' : 
                                        ($p->status === 'berjalan' ? 'success' : 'info') 
                                    }}">
                                        {{ ucfirst($p->status) }}
                                    </span>
                                </td>

                                <td class="text-center">{{ $p->penyelenggara ?? 'BGTK DKI Jakarta' }}</td>

                                <td class="text-center">
                                    @if($p->tanggal_mulai)
                                        {{ \Carbon\Carbon::parse($p->tanggal_mulai)->format('d M Y') }}
                                        @if($p->tanggal_selesai)
                                            <br><small>s/d {{ \Carbon\Carbon::parse($p->tanggal_selesai)->format('d M Y') }}</small>
                                        @endif
                                    @else
                                        -
                                    @endif
                                </td>

                                <td class="text-center">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                                data-bs-toggle="dropdown">
                                            <i class="bi bi-three-dots-vertical"></i>
                                        </button>

                                        <ul class="dropdown-menu dropdown-menu-end small shadow">
                                            <li>
                                                <a class="dropdown-item"
                                                   href="{{ route('pelatihan.kelola', $p->id) }}?tab=kelas">
                                                   <i class="bi bi-gear me-2 text-primary"></i> Kelola
                                                </a>
                                            </li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <a class="dropdown-item"
                                                   href="{{ route('pelatihan.edit', $p) }}">
                                                    <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <form action="{{ route('pelatihan.destroy', $p) }}"
                                                      method="POST"
                                                      onsubmit="return confirm('Yakin ingin menghapus data ini?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="dropdown-item text-danger">
                                                        <i class="bi bi-trash me-2"></i> Hapus
                                                    </button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted py-3">
                                    Belum ada data pelatihan
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $pelatihan->links() }}
            </div>

        </div>
    </div>

@endsection