@extends('layouts.admin')

@section('content')
<div class="container-fluid">

  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h4 class="mb-0 fw-bold">Kelola Pelatihan</h4>
      <div class="text-muted small">
        {{ $pelatihan->nama ?? $pelatihan->judul ?? 'Pelatihan #' . $pelatihan->id }}
      </div>
    </div>
    <a href="{{ route('pelatihan.index') }}" class="btn btn-sm btn-outline-secondary">
      <i class="bi bi-arrow-left"></i> Kembali
    </a>
  </div>

  @if(session('success'))
    <div class="alert alert-success py-2">{{ session('success') }}</div>
  @endif
  @if(session('error'))
    <div class="alert alert-danger py-2">{{ session('error') }}</div>
  @endif

  @php($activeTab = $tab ?? request('tab', 'kelas'))

  <ul class="nav nav-tabs">
    <li class="nav-item">
      <a class="nav-link {{ $activeTab === 'kelas' ? 'active' : '' }}"
        href="{{ route('pelatihan.kelola', $pelatihan->id) }}?tab=kelas">Kelas</a>
    </li>
    <li class="nav-item">
      <a class="nav-link {{ $activeTab === 'peserta' ? 'active' : '' }}"
        href="{{ route('pelatihan.kelola', $pelatihan->id) }}?tab=peserta">Peserta</a>
    </li>
  </ul>

  <div class="pt-3">
    {{-- TAB KELAS --}}
    @if($activeTab === 'kelas')
      <div class="card">
        <div class="card-body">
          <h6 class="fw-semibold mb-3">Tambah Kelas</h6>

          <form method="POST" action="{{ route('admin.pelatihan.kelas.store', $pelatihan->id) }}" class="row g-2">
            @csrf
            <div class="col-12 col-md-2">
              <input name="kode_kelas" class="form-control form-control-sm" placeholder="Kode" required>
            </div>
            <div class="col-12 col-md-7">
              <input name="nama_kelas" class="form-control form-control-sm" placeholder="Nama kelas" required>
            </div>
            <div class="col-12 col-md-3">
              <button class="btn btn-sm btn-primary w-100">Tambah</button>
            </div>
          </form>

          <hr class="my-3">

          <h6 class="fw-semibold mb-2">Daftar Kelas</h6>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead class="table-light">
                <tr>
                  <th style="width:120px;">Kode</th>
                  <th>Nama</th>
                  <th style="width:260px;" class="text-end">Aksi</th>
                </tr>
              </thead>
              <tbody>
                @forelse($kelasList as $k)
                  <tr>
                    <td class="fw-semibold">{{ $k->kode_kelas }}</td>
                    <td>{{ $k->nama_kelas }}</td>
                    <td class="text-center">
                      <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"
                          data-bs-toggle="dropdown" aria-expanded="false">
                          <i class="bi bi-three-dots-vertical"></i>
                        </button>

                        <ul class="dropdown-menu dropdown-menu-end small shadow">

                          {{-- DETAIL --}}
                          <li>
                            <a class="dropdown-item" href="{{ route('admin.kelas.show', $k->id) }}">
                              <i class="bi bi-eye me-2 text-info"></i> Detail
                            </a>
                          </li>

                          {{-- EDIT --}}
                          <li>
                            <button class="dropdown-item" type="button" data-bs-toggle="collapse"
                              data-bs-target="#editKelas{{ $k->id }}">
                              <i class="bi bi-pencil-square me-2 text-warning"></i> Edit
                            </button>
                          </li>

                          <li>
                            <hr class="dropdown-divider">
                          </li>

                          {{-- HAPUS --}}
                          <li>
                            <form method="POST"
                              action="{{ route('admin.pelatihan.kelas.destroy', [$pelatihan->id, $k->id]) }}"
                              onsubmit="return confirm('Yakin ingin menghapus kelas ini?');">
                              @csrf
                              @method('DELETE')

                              <button type="submit" class="dropdown-item text-danger">
                                <i class="bi bi-trash me-2"></i> Hapus
                              </button>
                            </form>
                          </li>

                        </ul>
                      </div>
                    </td>

                  </tr>

                  <tr class="collapse" id="editKelas{{ $k->id }}">
                    <td colspan="3">
                      <form method="POST" action="{{ route('admin.pelatihan.kelas.update', [$pelatihan->id, $k->id]) }}"
                        class="row g-2">
                        @csrf
                        @method('PUT')
                        <div class="col-12 col-md-2">
                          <input name="kode_kelas" value="{{ $k->kode_kelas }}" class="form-control form-control-sm"
                            required>
                        </div>
                        <div class="col-12 col-md-7">
                          <input name="nama_kelas" value="{{ $k->nama_kelas }}" class="form-control form-control-sm"
                            required>
                        </div>
                        <div class="col-12 col-md-3">
                          <button class="btn btn-sm btn-success w-100">Simpan</button>
                        </div>
                      </form>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="3" class="text-center text-muted py-4">Belum ada kelas.</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>

      {{-- TAB PESERTA --}}
    @else
      <div class="card">
        <div class="card-body">
          <h6 class="fw-semibold mb-3">Peserta Pelatihan</h6>

          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead class="table-light">
                <tr>
                  <th>Nama</th>
                  <th style="width:170px;">Kelas</th>
                  <th style="width:220px;" class="text-end">Aksi</th>
                </tr>
              </thead>
              <tbody>
                @forelse($pesertaPage as $p)
                  <tr>
                    <td>
                      <div class="fw-semibold">{{ $p->guru->nama ?? $p->guru->Name ?? 'Guru #' . $p->guru_id }}</div>
                      <div class="small text-muted">{{ $p->status_keikutsertaan ?? '-' }}</div>
                    </td>
                    <td>{{ $p->kelas->kode_kelas ?? '-' }}</td>
                    <td class="text-end">
                      <a href="{{ route('peserta.edit', $p->id) }}" class="btn btn-sm btn-outline-secondary">Edit</a>
                      <form method="POST" action="{{ route('peserta.destroy', $p->id) }}" class="d-inline"
                        onsubmit="return confirm('Hapus peserta dari pelatihan ini?');">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-outline-danger">Hapus</button>
                      </form>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="3" class="text-center text-muted py-4">Belum ada peserta.</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>

          <div class="mt-2">
            {{ $pesertaPage->withQueryString()->links() }}
          </div>
        </div>
      </div>
    @endif
  </div>

</div>
@endsection