@extends('layouts.admin')

@section('title', 'Detail Biodata Peserta')

@section('content')
<div class="container-fluid">

    {{-- HEADER --}}
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body d-flex justify-content-between align-items-center">
            <div>
                <h6 class="mb-1">Biodata Peserta</h6>
                <small class="text-muted">
                    Detail identitas, unit kerja, dan data pendukung peserta
                </small>
            </div>

            <div class="d-flex gap-2">
                <a href="{{ route('admin.registrasi.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="bi bi-arrow-left"></i> Kembali
                </a>

                <a href="#"
                class="btn btn-warning btn-sm">
                    <i class="bi bi-pencil-square"></i> Edit
                </a>
            </div>
        </div>
    </div>


    {{-- CARD UTAMA --}}
    <div class="card shadow-sm border-0 mb-4">
        <div class="card-body">
            <div class="row align-items-start">

                {{-- FOTO --}}
                <div class="col-md-3 text-center">
                    <div class="mb-3">
                        @if($registrasiPeserta->foto)
                            <img src="{{ asset('storage/'.$registrasiPeserta->foto) }}"
                                 class="img-fluid rounded shadow-sm"
                                 style="max-height: 220px"
                                 alt="Foto Peserta">
                        @else
                            <img src="{{ asset('images/default-user.png') }}"
                                 class="img-fluid rounded shadow-sm"
                                 style="max-height: 220px"
                                 alt="Foto Default">
                        @endif
                    </div>
                    <span class="badge bg-light text-dark">
                        {{ $registrasiPeserta->nama ?? '-' }}
                    </span>
                </div>

                {{-- DATA UTAMA --}}
                <div class="col-md-9">
                    <table class="table table-borderless table-sm mb-0">
                        <tr>
                            <th width="30%">Nama Kegiatan</th>
                            <td>: {{ $registrasiPeserta->nama_kegiatan ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Nama Lengkap</th>
                            <td>: {{ $registrasiPeserta->nama ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>NIK</th>
                            <td>: {{ $registrasiPeserta->nik ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>NIP</th>
                            <td>: {{ $registrasiPeserta->nip ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Jabatan</th>
                            <td>: {{ $registrasiPeserta->jabatan ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Pangkat / Golongan</th>
                            <td>: {{ $registrasiPeserta->pangkat_golongan ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Agama</th>
                            <td>: {{ $registrasiPeserta->agama ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Jenis Kelamin</th>
                            <td>: {{ $registrasiPeserta->jenis_kelamin ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Tempat, Tanggal Lahir</th>
                            <td>
                                : {{ $registrasiPeserta->tempat_lahir ?? '-' }},
                                {{ $registrasiPeserta->tanggal_lahir
                                    ? \Carbon\Carbon::parse($registrasiPeserta->tanggal_lahir)->format('d-m-Y')
                                    : '-' }}
                            </td>
                        </tr>
                        <tr>
                            <th>No HP</th>
                            <td>: {{ $registrasiPeserta->no_hp ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Email Pribadi</th>
                            <td>: {{ $registrasiPeserta->email_pribadi ?? '-' }}</td>
                        </tr>
                    </table>
                </div>

            </div>
        </div>
    </div>

    {{-- PENDIDIKAN --}}
    <div class="card shadow-sm border-0 mb-3">
        <div class="card-header bg-light fw-semibold">
            <i class="bi bi-mortarboard"></i> Pendidikan
        </div>
        <div class="card-body">
            <table class="table table-borderless table-sm mb-0">
                <tr>
                    <th width="30%">Pendidikan Terakhir</th>
                    <td>: {{ $registrasiPeserta->pendidikan_terakhir ?? '-' }}</td>
                </tr>
                <tr>
                    <th>Program Studi</th>
                    <td>: {{ $registrasiPeserta->prodi ?? '-' }}</td>
                </tr>
            </table>
        </div>
    </div>

    {{-- UNIT KERJA --}}
    <div class="card shadow-sm border-0 mb-3">
        <div class="card-header bg-light fw-semibold">
            <i class="bi bi-building"></i> Unit Kerja
        </div>
        <div class="card-body">
            <table class="table table-borderless table-sm mb-0">
                <tr>
                    <th width="30%">Unit Kerja</th>
                    <td>: {{ $registrasiPeserta->unit_kerja ?? '-' }}</td>
                </tr>
                <tr>
                    <th>Alamat Unit Kerja</th>
                    <td>
                        : {{ $registrasiPeserta->alamat_unit_kerja ?? '-' }},
                        {{ $registrasiPeserta->kab_kota_unit ?? '-' }},
                        {{ $registrasiPeserta->provinsi_unit ?? '-' }},
                        {{ $registrasiPeserta->kode_pos_unit ?? '-' }}
                    </td>
                </tr>
                <tr>
                    <th>Telepon Instansi</th>
                    <td>: {{ $registrasiPeserta->telp_instansi ?? '-' }}</td>
                </tr>
            </table>
        </div>
    </div>

    {{-- ALAMAT RUMAH --}}
    <div class="card shadow-sm border-0 mb-3">
        <div class="card-header bg-light fw-semibold">
            <i class="bi bi-house"></i> Alamat Rumah
        </div>
        <div class="card-body">
            <table class="table table-borderless table-sm mb-0">
                <tr>
                    <th width="30%">Alamat</th>
                    <td>
                        : {{ $registrasiPeserta->alamat_rumah ?? '-' }},
                        {{ $registrasiPeserta->kab_kota_rumah ?? '-' }},
                        {{ $registrasiPeserta->provinsi_rumah ?? '-' }},
                        {{ $registrasiPeserta->kode_pos_rumah ?? '-' }}
                    </td>
                </tr>
            </table>
        </div>
    </div>

    {{-- KEUANGAN --}}
    <div class="card shadow-sm border-0">
        <div class="card-header bg-light fw-semibold">
            <i class="bi bi-wallet2"></i> Data Keuangan
        </div>
        <div class="card-body">
            <table class="table table-borderless table-sm mb-0">
                <tr>
                    <th width="30%">NPWP</th>
                    <td>: {{ $registrasiPeserta->npwp ?? '-' }}</td>
                </tr>
                <tr>
                    <th>Bank</th>
                    <td>: {{ $registrasiPeserta->bank ?? '-' }}</td>
                </tr>
                <tr>
                    <th>No Rekening</th>
                    <td>: {{ $registrasiPeserta->no_rekening ?? '-' }}</td>
                </tr>
            </table>
        </div>
    </div>

</div>
@endsection
