<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Register - BGTK DKI</title>

    {{-- Bootstrap 5 --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    {{-- Bootstrap Icons --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

    <style>
        body {
            min-height: 100vh;
            background: #f3f4f6;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1.5rem;
        }
        .auth-wrapper {
            max-width: 420px;
            width: 100%;
        }
        .auth-card {
            border-radius: 1.5rem;
            border: 1px solid #e5e7eb;
            background: #ffffff;
            box-shadow: 0 20px 45px rgba(15, 23, 42, 0.18);
            padding: 2rem 2.25rem;
        }
        .auth-logo {
            width: 180px;
            height: auto;
            object-fit: contain;
            margin-bottom: 0 !important; 
        }
        .auth-card h4 {
            margin-top: -15px !important; 
            letter-spacing: 0.05em;
            position: relative;
            z-index: 2;
        }
        
        .auth-card p {
            margin-top: -4px;
        }
        .auth-title {
            letter-spacing: 0.1em;
        }
        .input-icon {
            width: 38px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
        }
        .form-control:focus {
            box-shadow: 0 0 0 0.15rem rgba(37, 99, 235, 0.25);
        }
        .btn-primary {
            background: #2563eb;
            border-color: #2563eb;
        }
        .btn-primary:hover {
            background: #1d4ed8;
            border-color: #1d4ed8;
        }
        .toggle-password-btn {
            border: none;
            background: transparent;
            color: #6b7280;
        }
    </style>
</head>
<body>
<div class="auth-wrapper">

    <div class="auth-card">
            {{-- Logo + Title --}}
            <div class="text-center mb-4">
                <img src="{{ asset('images/logo_terbaru1.png') }}"
                    alt="Logo BGTK DKI"
                    class="auth-logo">

                {{-- JUDUL + SUBJUDUL --}}
                <h4 class="mb-0 fw-bold">REGISTER</h4>
                <p class="mb-0 small opacity-75">
                    Sistem Informasi BGTK DKI Jakarta
                </p>
            </div>

        {{-- Error --}}
        @if($errors->any())
            <div class="alert alert-danger py-2 small">
                {{ $errors->first() }}
            </div>
        @endif

        <form method="POST" action="{{ route('register.store') }}">
            @csrf

            {{-- Nama --}}
            <div class="mb-3">
                <label class="form-label small mb-1">Nama Lengkap</label>
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-white input-icon">
                        <i class="bi bi-person"></i>
                    </span>
                    <input
                        type="text"
                        name="name"
                        class="form-control @error('name') is-invalid @enderror"
                        value="{{ old('name') }}"
                        required
                        autocomplete="name"
                    >
                </div>
            </div>

            {{-- Email --}}
            <div class="mb-3">
                <label class="form-label small mb-1">Email</label>
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-white input-icon">
                        <i class="bi bi-envelope"></i>
                    </span>
                    <input
                        type="email"
                        name="email"
                        class="form-control @error('email') is-invalid @enderror"
                        value="{{ old('email') }}"
                        required
                        autocomplete="email"
                    >
                </div>
            </div>

            {{-- Password --}}
            <div class="mb-3">
                <label class="form-label small mb-1">Password</label>
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-white input-icon">
                        <i class="bi bi-lock"></i>
                    </span>
                    <input
                        type="password"
                        name="password"
                        id="reg_password"
                        class="form-control @error('password') is-invalid @enderror"
                        required
                        autocomplete="new-password"
                    >
                    <button type="button"
                            class="input-group-text toggle-password-btn"
                            data-target="#reg_password">
                        <i class="bi bi-eye-slash"></i>
                    </button>
                </div>
            </div>

            {{-- Konfirmasi Password --}}
            <div class="mb-3">
                <label class="form-label small mb-1">Konfirmasi Password</label>
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-white input-icon">
                        <i class="bi bi-lock"></i>
                    </span>
                    <input
                        type="password"
                        name="password_confirmation"
                        id="reg_password_confirmation"
                        class="form-control"
                        required
                        autocomplete="new-password"
                    >
                    <button type="button"
                            class="input-group-text toggle-password-btn"
                            data-target="#reg_password_confirmation">
                        <i class="bi bi-eye-slash"></i>
                    </button>
                </div>
            </div>

            {{-- Tombol submit --}}
            <div class="d-grid mb-3">
                <button type="submit" class="btn btn-primary btn-sm py-2">
                    Daftar
                </button>
            </div>

            {{-- Link ke login --}}
            <div class="text-center small">
                Sudah memiliki akun?
                <a href="{{ route('login') }}" class="text-decoration-none">
                    Silakan Login!
                </a>
            </div>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.querySelectorAll('.toggle-password-btn').forEach(function (btn) {
        btn.addEventListener('click', function () {
            const target = document.querySelector(this.dataset.target);
            const icon = this.querySelector('i');
            if (!target) return;

            if (target.type === 'password') {
                target.type = 'text';
                icon.classList.remove('bi-eye-slash');
                icon.classList.add('bi-eye');
            } else {
                target.type = 'password';
                icon.classList.remove('bi-eye');
                icon.classList.add('bi-eye-slash');
            }
        });
    });
</script>
</body>
</html>
