<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'Portal Data BGTK DKI Jakarta')</title>

    <link rel="shortcut icon" href="{{ asset('images/bgtk-logo.png') }}" type="image/png">

    {{-- Mazer CSS (Light + Dark) --}}
    <link rel="stylesheet" href="{{ asset('assets/compiled/css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/compiled/css/app-dark.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/extensions/bootstrap-icons/font/bootstrap-icons.css') }}">

    {{-- Portal custom style --}}
    <link rel="stylesheet" href="{{ asset('assets/compiled/css/portal.css') }}">

    {{-- Init theme before paint --}}
    <script src="{{ asset('assets/static/js/initTheme.js') }}"></script>

    @stack('styles')
</head>
<body>

<nav class="navbar navbar-expand-lg portal-navbar sticky-top">
    <div class="container-fluid px-3 px-md-4 portal-shell">

        <a class="portal-brand d-flex align-items-center gap-2" href="{{ route('portal.dashboard') }}">
            <span class="brand-mark overflow-hidden">
                <img src="{{ asset('images/Logo.png') }}" alt="BGTK">
            </span>
            <span class="d-none d-sm-flex flex-column lh-sm">
                <span class="fw-bold" style="font-size:.95rem;">BGTK DKI Jakarta</span>
                <span class="text-muted" style="font-size:.78rem;">Portal Data & Informasi</span>
            </span>
        </a>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#portalNav" aria-controls="portalNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="portalNav">
            <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('portal.dashboard') ? 'active' : '' }}" href="{{ route('portal.dashboard') }}">
                        Beranda
                    </a>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle {{ request()->routeIs('portal.guru.*') ? 'active' : '' }}" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Data Pokok
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="{{ route('portal.guru.index') }}">
                                <i class="bi bi-people me-2"></i>Daftar Guru
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item disabled" href="#">
                                <i class="bi bi-building me-2"></i>Daftar Sekolah
                            </a>
                        </li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Pelatihan
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item disabled" href="#">
                                <i class="bi bi-mortarboard me-2"></i>Daftar Pelatihan
                            </a>
                        </li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Dokumen Keuangan
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item disabled" href="#">
                                <i class="bi bi-receipt me-2"></i>SPD & Kuitansi
                            </a>
                        </li>
                    </ul>
                </li>
                    <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('portal.registrasi.create') ? 'active' : '' }}" href="{{ route('portal.registrasi.create') }}">
                        Form Registrasi
                    </a>
                </li>
            </ul>

            <div class="d-flex align-items-center gap-2">
                <div class="theme-toggle d-flex gap-2 align-items-center">
                    <i class="bi bi-sun"></i>
                    <div class="form-check form-switch fs-6 m-0">
                        <input class="form-check-input me-0" type="checkbox" id="toggle-dark" style="cursor:pointer">
                        <label class="form-check-label"></label>
                    </div>
                    <i class="bi bi-moon"></i>
                </div>

                <form method="POST" action="{{ route('logout') }}" class="ms-1">
                    @csrf
                    <button type="submit" class="btn btn-outline-dark btn-sm rounded-pill px-3">
                        <i class="bi bi-box-arrow-right me-1"></i>Keluar
                    </button>
                </form>
            </div>
        </div>
    </div>
</nav>

<main class="py-4">
    <div class="portal-shell px-3 px-md-4">
        @yield('content')
    </div>
</main>

<footer class="portal-footer">
    <div class="portal-shell px-3 px-md-4">
        <div class="row g-4">
            <div class="col-12 col-md-4">
                <div class="d-flex align-items-center gap-2">
                    <img src="{{ asset('images/Logo.png') }}" alt="BGTK" style="height:42px;width:auto;">
                    <div>
                        <div class="footer-title">BGTK DKI Jakarta</div>
                        <div class="small">Balai Guru dan Tenaga Kependidikan</div>
                    </div>
                </div>
                <p class="small mt-2 mb-0">
                    Temukan beragam data resmi pendidikan dan kebahasaan dalam satu portal.
                </p>
            </div>

            <div class="col-12 col-md-4">
                <div class="footer-title mb-2">Alamat Kantor</div>
                <div class="small">
                Jl. Gardu No.10 10, RT.10/RW.2, Srengseng Sawah,
                Kec. Jagakarsa, Kota Jakarta Selatan,
                Daerah Khusus Ibukota Jakarta 14270
                </div>
                <div class="small mt-2">
                    <i class="bi bi-clock me-1"></i>Senin – Jumat, 08.00 – 16.00
                </div>
            </div>

            <div class="col-12 col-md-4">
                <div class="footer-title mb-2">Kontak Kami</div>
                <div class="small"><i class="bi bi-telephone me-1"></i>(021) 741 8808</div>
                <div class="small"><i class="bi bi-envelope me-1"></i>pusdatin@kemendikdasmen.go.id</div>

                <div class="footer-title mt-3 mb-2">Sosial Media</div>
                <div class="d-flex align-items-center gap-2">
                    <a href="#" aria-label="Instagram"><i class="bi bi-instagram fs-5"></i></a>
                    <a href="#" aria-label="YouTube"><i class="bi bi-youtube fs-5"></i></a>
                    <a href="#" aria-label="Facebook"><i class="bi bi-facebook fs-5"></i></a>
                    <a href="#" aria-label="TikTok"><i class="bi bi-tiktok fs-5"></i></a>
                </div>
            </div>
        </div>

        <div class="small text-center mt-4">
            Hak Cipta © {{ date('Y') }} Balai Guru dan Tenaga Kependidikan DKI Jakarta. All rights reserved.
        </div>
    </div>
</footer>

{{-- Mazer JS --}}
<script src="{{ asset('assets/static/js/components/dark.js') }}"></script>
<script src="{{ asset('assets/compiled/js/app.js') }}"></script>

@stack('scripts')
</body>
</html>
