<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>@yield('title', 'Beranda Peserta - BGTK DKI')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    {{-- Tailwind CDN --}}
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        body {
            @apply bg-slate-50;
        }
        .container-limit {
            @apply max-w-6xl mx-auto px-4;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">

{{-- NAVBAR ATAS KHUSUS USER --}}
<header class="bg-white/90 backdrop-blur border-b border-slate-200 sticky top-0 z-20">
    <div class="container-limit flex items-center justify-between py-3">
        <div class="flex items-center gap-2">
            <div class="w-9 h-9 rounded-full bg-sky-600 flex items-center justify-center text-white text-sm font-bold">
                BGTK
            </div>
            <div>
                <div class="text-sm font-semibold text-slate-900">
                    BGTK Provinsi DKI Jakarta
                </div>
                <div class="text-[11px] text-slate-500">
                    Sistem Informasi Pelatihan Guru
                </div>
            </div>
        </div>

        <nav class="hidden md:flex items-center gap-5 text-xs font-medium text-slate-600">
            <a href="{{ route('dashboard') }}"
               class="hover:text-sky-700 @if(request()->routeIs('dashboard')) text-sky-700 @endif">
                Beranda
            </a>
            <a href="{{ route('peserta.pelatihanSaya') }}"
               class="hover:text-sky-700 @if(request()->routeIs('peserta.pelatihanSaya')) text-sky-700 @endif">
                Pelatihan Saya
            </a>
        </nav>

        <div class="flex items-center gap-3">
            @php
                $authUser = auth()->user();
                $guruContext = isset($guru) ? $guru : ($authUser->guru ?? null);
            @endphp

            <span class="hidden sm:inline text-[11px] text-slate-500">
                {{ $guruContext->nama_guru ?? $authUser->name }}
            </span>

            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit"
                        class="inline-flex items-center px-3 py-1.5 rounded-full text-[11px] font-semibold bg-slate-900 text-white hover:bg-slate-800">
                    Keluar
                </button>
            </form>
        </div>
    </div>
</header>

<main class="flex-1 py-6">
    <div class="container-limit space-y-6">
        @yield('content')
    </div>
</main>

<footer class="border-t border-slate-200 py-4 mt-4 bg-white">
    <div class="container-limit flex flex-col sm:flex-row items-center justify-between gap-2">
        <p class="text-[11px] text-slate-500">
            &copy; {{ date('Y') }} BGTK Provinsi DKI Jakarta. Sistem Informasi Pelatihan Guru.
        </p>
        <p class="text-[11px] text-slate-400">
            Data bersumber dari BGTK & Dapodik (jika sudah terintegrasi).
        </p>
    </div>
</footer>

</body>
</html>
