@extends('layouts.portal')

@section('title', 'Detail Guru')

@section('content')

<nav aria-label="breadcrumb" class="mb-3">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item"><a href="{{ route('portal.dashboard') }}">Beranda</a></li>
        <li class="breadcrumb-item"><a href="{{ route('portal.guru.index') }}">Data Guru</a></li>
        <li class="breadcrumb-item active" aria-current="page">Detail</li>
    </ol>
</nav>

<h4 class="fw-bold mb-3">Data Guru</h4>

<div class="card mb-4">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-12 col-lg-6">
                <div class="row g-3">
                    <div class="col-12 col-sm-6">
                        <div class="kv">
                            <div class="k">Nama</div>
                            <div class="v">{{ $guru->nama_guru }}</div>
                        </div>
                    </div>
                    <div class="col-12 col-sm-6">
                        <div class="kv">
                            <div class="k">Jenis Kelamin</div>
                            <div class="v">{{ $guru->jenis_kelamin ?: '-' }}</div>
                        </div>
                    </div>

                    <div class="col-12 col-sm-6">
                        <div class="kv">
                            <div class="k">Asal Sekolah</div>
                            <div class="v">{{ $guru->sekolah->nama ?? ($guru->instansi ?? '-') }}</div>
                        </div>
                    </div>
                    <div class="col-12 col-sm-6">
                        <div class="kv">
                            <div class="k">Status Kepegawaian</div>
                            <div class="v">{{ $guru->status_kepegawaian ?: '-' }}</div>
                        </div>
                    </div>

                    <div class="col-12 col-sm-6">
                        <div class="kv">
                            <div class="k">NIP</div>
                            <div class="v">{{ $guru->nip ?: '-' }}</div>
                        </div>
                    </div>
                    <div class="col-12 col-sm-6">
                        <div class="kv">
                            <div class="k">Status Keaktifan</div>
                            <div class="v">{{ $guru->status_keaktifan ?: '-' }}</div>
                        </div>
                    </div>

                    <div class="col-12 col-sm-6">
                        <div class="kv">
                            <div class="k">Tempat, tanggal lahir</div>
                            <div class="v">
                                {{ $guru->tempat_lahir ?: '-' }}{{ $guru->tanggal_lahir ? ', ' . $guru->tanggal_lahir->translatedFormat('d F Y') : '' }}
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-sm-6">
                        <div class="kv">
                            <div class="k">Pendidikan Terakhir</div>
                            <div class="v">{{ $guru->riwayat_pendidikan_formal_jenjang_pendidikan ?: '-' }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 col-lg-6">
                <div class="p-3 rounded-4 border" style="background: rgba(var(--bs-primary-rgb), .04)">
                    <div class="d-flex flex-column gap-2">
                        <div class="d-flex justify-content-between">
                            <span class="text-muted">NIK</span>
                            <span class="fw-bold">{{ $guru->nik ?: '-' }}</span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="text-muted">NUPTK</span>
                            <span class="fw-bold">{{ $guru->nuptk ?: '-' }}</span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="text-muted">Bidang</span>
                            <span class="fw-bold">{{ $guru->bidangBahasa->nama_bahasa ?? '-' }}</span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="text-muted">Kota/Kabupaten</span>
                            <span class="fw-bold">{{ $guru->sekolah->kabupaten ?? ($guru->kab_kota ?? '-') }}</span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="text-muted">Jenjang</span>
                            <span class="fw-bold">{{ $guru->sekolah->jenjang ?? '-' }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<h5 class="fw-bold mb-2">Riwayat Guru</h5>

<div class="card">
    <div class="card-body">
        <ul class="nav nav-tabs" id="riwayatTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="tab-pendidikan" data-bs-toggle="tab" data-bs-target="#pane-pendidikan" type="button" role="tab">
                    Riwayat Pendidikan
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-pelatihan" data-bs-toggle="tab" data-bs-target="#pane-pelatihan" type="button" role="tab">
                    Riwayat Pelatihan
                </button>
            </li>
        </ul>

        <div class="tab-content pt-3" id="riwayatTabsContent">
            <div class="tab-pane fade show active" id="pane-pendidikan" role="tabpanel" aria-labelledby="tab-pendidikan">
                <div class="table-soft">
                    <div class="table-responsive">
                        <table class="table mb-0 align-middle">
                            <thead>
                            <tr>
                                <th>Asal Kampus</th>
                                <th>Bidang Studi</th>
                                <th>Jenjang Pendidikan</th>
                                <th>Jabatan</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>{{ $guru->instansi ?: '-' }}</td>
                                <td>{{ $guru->riwayat_pendidikan_formal_bidang_studi ?: '-' }}</td>
                                <td>{{ $guru->riwayat_pendidikan_formal_jenjang_pendidikan ?: '-' }}</td>
                                <td>{{ $guru->jabatan ?: ($guru->jabatan_ptk ?: '-') }}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="pane-pelatihan" role="tabpanel" aria-labelledby="tab-pelatihan">
                <div class="table-soft">
                    <div class="table-responsive">
                        <table class="table mb-0 align-middle">
                            <thead>
                            <tr>
                                <th style="min-width:240px;">Nama Pelatihan</th>
                                <th style="min-width:160px;">Status</th>
                                <th style="min-width:160px;">Nomor Sertifikat</th>
                                <th style="min-width:140px;">Tanggal</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($pelatihan as $p)
                                <tr>
                                    <td class="fw-semibold">{{ $p->pelatihan->nama_kegiatan ?? '-' }}</td>
                                    <td>{{ $p->status_keikutsertaan ?: '-' }}</td>
                                    <td>{{ $p->nomor_sertifikat ?: '-' }}</td>
                                    <td>{{ optional($p->created_at)->format('d/m/Y') }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">
                                        Belum ada riwayat pelatihan.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection