<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\GuruController;
use App\Http\Controllers\PegawaiController;

use App\Http\Controllers\SekolahController;
use App\Http\Controllers\DashboardController;

use App\Http\Controllers\PelatihanController;
use App\Http\Controllers\SkKegiatanController;
use App\Http\Controllers\SuratTugasController;

use App\Http\Controllers\Admin\KelasController;

use App\Http\Controllers\DaftarHadirController;

use App\Http\Controllers\Portal\PortalController;

use App\Http\Controllers\Admin\KegiatanController;

use App\Http\Controllers\PelatihanPesertaController;
use App\Http\Controllers\PesertaDashboardController;

use App\Http\Controllers\Portal\PortalGuruController;
use App\Http\Controllers\RegistrasiPesertaController;

use App\Http\Controllers\Select2\PtkSelect2Controller;

use App\Http\Controllers\Admin\PelatihanKelasController;
use App\Http\Controllers\Fasil\FasilDashboardController;
use App\Http\Controllers\Admin\LaporanKegiatanController;
use App\Http\Controllers\Admin\Keuangan\KuitansiController;
use App\Http\Controllers\Admin\Keuangan\SpdRincianController;
use App\Http\Controllers\Admin\PelatihanKelasJadwalController as KelasJadwalController;
use App\Http\Controllers\DaftarHadirNarasumberController;

Route::get('/', function () {
    if (auth()->check()) {
        $role = auth()->user()?->role?->name;

        if (in_array($role, ['admin', 'administrator'], true)) return redirect()->route('admin.dashboard');
        if ($role === 'fasil') return redirect()->route('fasil.dashboard');
        return redirect()->route('portal.dashboard');
    }

    return redirect()->route('login');
});

// ================= PORTAL PUBLIK (USER) =================
Route::get('/portal', [PortalController::class, 'index'])->name('portal.dashboard');
Route::get('/data-guru', [PortalGuruController::class, 'index'])->name('portal.guru.index');
Route::get('/data-guru/{guru}', [PortalGuruController::class, 'show'])->name('portal.guru.show');

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post');

Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register'])->name('register.store');

Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::middleware('auth')->group(function () {

    // ================= USER (GURU/PESERTA) =================
    Route::middleware('role:user,peserta')->group(function () {

        Route::get('/dashboard', [PesertaDashboardController::class, 'index'])->name('dashboard');

        Route::get('/pelatihan-saya', [PesertaDashboardController::class, 'pelatihanSaya'])
            ->name('peserta.pelatihanSaya');

        Route::get('/pelatihan-peserta/{peserta}/download-sertifikat', [PelatihanPesertaController::class, 'downloadSertifikat'])
            ->name('pelatihan.peserta.downloadSertifikat');

        // FORM REGISTRASI (USER)
        Route::get('/registrasi', [RegistrasiPesertaController::class, 'create'])->name('portal.registrasi.create');
        Route::post('/registrasi', [RegistrasiPesertaController::class, 'store'])->name('portal.registrasi.store');
        Route::get('/registrasi/success', [RegistrasiPesertaController::class, 'success'])->name('portal.registrasi.success');
    });

    // ================= ADMIN =================
    Route::middleware('role:admin,administrator')->prefix('admin')->group(function () {

        Route::get('dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');

        Route::get('/select2/ptk', [PtkSelect2Controller::class, 'index'])
            ->name('ptk.select2');


        // ================= GURU =================
        Route::get('guru/select2', [GuruController::class, 'select2'])->name('guru.select2');
        Route::get('guru/export', [GuruController::class, 'export'])->name('guru.export');
        Route::post('guru/import', [GuruController::class, 'import'])->name('guru.import');
        Route::resource('guru', GuruController::class)->except(['show']);
        Route::get('guru/{guru}', [GuruController::class, 'show'])->name('guru.show');

        // ================= SEKOLAH =================
        Route::get('sekolah/export', [SekolahController::class, 'export'])->name('sekolah.export');
        Route::post('sekolah/import', [SekolahController::class, 'import'])->name('sekolah.import');
        Route::resource('sekolah', SekolahController::class)->except(['show']);
        Route::get('sekolah/{sekolah}', [SekolahController::class, 'show'])->name('sekolah.show');

        // ================ PEGAWAI BGTK =============
        Route::get('pegawai/select2', [App\Http\Controllers\PegawaiController::class, 'select2'])->name('pegawai.select2');
        Route::get('pegawai/export', [App\Http\Controllers\PegawaiController::class, 'export'])->name('pegawai.export');
        Route::post('pegawai/import', [App\Http\Controllers\PegawaiController::class, 'import'])->name('pegawai.import');
        Route::resource('pegawai', App\Http\Controllers\PegawaiController::class)->except(['show']);
        Route::get('pegawai/{pegawai}', [App\Http\Controllers\PegawaiController::class, 'show'])->name('pegawai.show');


        // =========================
        // PELATIHAN (CRUD utama)
        // =========================
        Route::resource('pelatihan', PelatihanController::class);

        // Halaman "Kelola" (Tab: Kelas & Peserta)
        Route::get('pelatihan/{pelatihan}/kelola', [PelatihanController::class, 'kelola'])
            ->name('pelatihan.kelola');

        // =========================
        // KELAS (CRUD)
        // =========================
        Route::post('pelatihan/{pelatihan}/kelas', [PelatihanKelasController::class, 'store'])
            ->name('admin.pelatihan.kelas.store');

        Route::put('pelatihan/{pelatihan}/kelas/{kelas}', [PelatihanKelasController::class, 'update'])
            ->name('admin.pelatihan.kelas.update');

        Route::delete('pelatihan/{pelatihan}/kelas/{kelas}', [PelatihanKelasController::class, 'destroy'])
            ->name('admin.pelatihan.kelas.destroy');

        // INPUT MANUAL FASIL
        Route::post(
            '/admin/kelas/{kelas}/fasil',
            [KelasController::class, 'storeFasil']
        )->name('admin.kelas.fasil.store');

        Route::delete(
            '/admin/kelas/{kelas}/fasil',
            [KelasController::class, 'storeFasil']
        )->name('admin.kelas.fasil.destroy');


        // Detail kelas + pengelola + peserta kelas
        Route::get('kelas/{kelas}', [PelatihanKelasController::class, 'show'])->name('admin.kelas.show');
        Route::put('kelas/{kelas}/pengelola', [PelatihanKelasController::class, 'updatePengelola'])->name('admin.kelas.pengelola.update');
        Route::post('kelas/{kelas}/assign-peserta', [PelatihanKelasController::class, 'assignPeserta'])->name('admin.kelas.peserta.assign');
        Route::delete('kelas/{kelas}/remove-peserta/{peserta}', [PelatihanKelasController::class, 'removePeserta'])->name('admin.kelas.peserta.remove');

        Route::resource('peserta', PelatihanPesertaController::class)->parameters([
            'peserta' => 'peserta',
        ]);

        // =========================
        // JADWAL KELAS + ADMINISTRASI (ABSENSI)
        // =========================
        Route::get('kelas/{kelas}/jadwal', [KelasJadwalController::class, 'index'])->name('admin.kelas.jadwal.index');
        Route::get('kelas/{kelas}/jadwal/create', [KelasJadwalController::class, 'create'])->name('admin.kelas.jadwal.create');
        Route::post('kelas/{kelas}/jadwal', [KelasJadwalController::class, 'store'])->name('admin.kelas.jadwal.store');
        Route::get('kelas/{kelas}/jadwal/{jadwal}/edit', [KelasJadwalController::class, 'edit'])->name('admin.kelas.jadwal.edit');
        Route::put('kelas/{kelas}/jadwal/{jadwal}', [KelasJadwalController::class, 'update'])->name('admin.kelas.jadwal.update');
        Route::delete('kelas/{kelas}/jadwal/{jadwal}', [KelasJadwalController::class, 'destroy'])->name('admin.kelas.jadwal.destroy');

        Route::get('kelas/{kelas}/jadwal/{jadwal}/absensi-peserta', [KelasJadwalController::class, 'printAbsensiPeserta'])->name('admin.kelas.jadwal.absensi_peserta');
        Route::get('kelas/{kelas}/jadwal/{jadwal}/absensi-fasil', [KelasJadwalController::class, 'printAbsensiFasil'])->name('admin.kelas.jadwal.absensi_fasil');

        // =========================
        // KEGIATAN + PIC
        // =========================
        Route::get('kelas/{kelas}/kegiatan', [KegiatanController::class, 'index'])->name('admin.kelas.kegiatan.index');
        Route::get('kelas/{kelas}/kegiatan/create', [KegiatanController::class, 'create'])->name('admin.kelas.kegiatan.create');
        Route::post('kelas/{kelas}/kegiatan', [KegiatanController::class, 'store'])->name('admin.kelas.kegiatan.store');
        Route::get('kelas/{kelas}/kegiatan/{kegiatan}', [KegiatanController::class, 'show'])->name('admin.kelas.kegiatan.show');
        Route::get('kelas/{kelas}/kegiatan/{kegiatan}/edit', [KegiatanController::class, 'edit'])->name('admin.kelas.kegiatan.edit');
        Route::put('kelas/{kelas}/kegiatan/{kegiatan}', [KegiatanController::class, 'update'])->name('admin.kelas.kegiatan.update');
        Route::delete('kelas/{kelas}/kegiatan/{kegiatan}', [KegiatanController::class, 'destroy'])->name('admin.kelas.kegiatan.destroy');

        // =========================
        // SURAT KEGIATAN
        // =========================

        // SK Kegiatan
        Route::resource('sk', SkKegiatanController::class);
        Route::get('/sk/{sk}/cetak', [SkKegiatanController::class, 'cetak'])->name('sk.cetak');

        // Surat Tugas
        Route::resource('surat-tugas', SuratTugasController::class)->parameters(['surat-tugas' => 'surat']);
        Route::get('surat-tugas/{id}/cetak',[SuratTugasController::class, 'cetak'])->name('surat-tugas.cetak');

        /*
        |--------------------------------------------------------------------------
        | DAFTAR HADIR PESERTA
        |--------------------------------------------------------------------------
        */
        Route::get('/daftar-hadir', [DaftarHadirController::class, 'index'])->name('daftar-hadir.index');
        Route::get('/daftar-hadir/create', [DaftarHadirController::class, 'create'])->name('daftar-hadir.create');
        Route::post('/daftar-hadir', [DaftarHadirController::class, 'store'])->name('daftar-hadir.store');
        Route::get('/daftar-hadir/{id}/edit', [DaftarHadirController::class, 'edit'])->name('daftar-hadir.edit');
        Route::put('/daftar-hadir/{id}', [DaftarHadirController::class, 'update'])->name('daftar-hadir.update');
        Route::delete('/daftar-hadir/{id}', [DaftarHadirController::class, 'destroy'])->name('daftar-hadir.destroy');
        Route::get('/daftar-hadir/{id}/cetak', [DaftarHadirController::class, 'cetak'])->name('daftar-hadir.cetak');

        /*
        |--------------------------------------------------------------------------
        | DAFTAR HADIR NARASUMBER 
        |--------------------------------------------------------------------------
        */
        Route::get('/daftar-hadir/{id}/narasumber',[DaftarHadirNarasumberController::class, 'index'])->name('daftar-hadir-narasumber.index');
        Route::get('/daftar-hadir/{id}/narasumber/create',[DaftarHadirNarasumberController::class, 'create'])->name('daftar-hadir-narasumber.create');
        Route::post('/daftar-hadir/{id}/narasumber',[DaftarHadirNarasumberController::class, 'store'])->name('daftar-hadir-narasumber.store');
        Route::get('/daftar-hadir/{id}/narasumber/edit',[DaftarHadirNarasumberController::class, 'edit'])->name('daftar-hadir-narasumber.edit');
        Route::put('/daftar-hadir/{id}/narasumber',[DaftarHadirNarasumberController::class, 'update'])->name('daftar-hadir-narasumber.update');
        Route::delete('/daftar-hadir/{id}/narasumber',[DaftarHadirNarasumberController::class, 'destroy'])->name('daftar-hadir-narasumber.destroy');
        Route::get('/daftar-hadir/{id}/narasumber/cetak',[DaftarHadirNarasumberController::class, 'cetak'])->name('daftar-hadir-narasumber.cetak');

        // =========================
        // LAPORAN KEGIATAN
        // =========================
        Route::get('laporan-kegiatan', [LaporanKegiatanController::class, 'index'])
            ->name('admin.laporan.index');

        Route::get('laporan-kegiatan', [LaporanKegiatanController::class, 'index'])
            ->name('admin.laporan-kegiatan.index');

        Route::get('laporan-kegiatan/{jadwal}/download', [LaporanKegiatanController::class, 'downloadLaporan'])
            ->name('admin.laporan.download');

        Route::get('laporan-kegiatan/{jadwal}/download', [LaporanKegiatanController::class, 'downloadLaporan'])
            ->name('admin.laporan-kegiatan.downloadLaporan');

        Route::get('laporan-kegiatan/{jadwal}/daftar-hadir-peserta', [LaporanKegiatanController::class, 'downloadDaftarHadirPeserta'])
            ->name('admin.laporan.absensi.peserta');

        Route::get('laporan-kegiatan/{jadwal}/daftar-hadir-peserta', [LaporanKegiatanController::class, 'downloadDaftarHadirPeserta'])
            ->name('admin.laporan-kegiatan.downloadDaftarHadirPeserta');

        Route::get('laporan-kegiatan/{jadwal}/daftar-hadir-fasil', [LaporanKegiatanController::class, 'downloadDaftarHadirFasil'])
            ->name('admin.laporan.absensi.fasil');

        Route::get('laporan-kegiatan/{jadwal}/daftar-hadir-fasil', [LaporanKegiatanController::class, 'downloadDaftarHadirFasil'])
            ->name('admin.laporan-kegiatan.downloadDaftarHadirFasil');

        // =========================
        // DATA REGISTRASI
        // =========================
        Route::get('registrasi', [RegistrasiPesertaController::class, 'index'])->name('admin.registrasi.index');
        Route::post('registrasi/import', [RegistrasiPesertaController::class, 'import'])->name('admin.registrasi.import');
        Route::get('registrasi/{registrasi}', [RegistrasiPesertaController::class, 'show'])->name('admin.registrasi.show');
        Route::get('registrasi/{registrasi}/edit', [RegistrasiPesertaController::class, 'edit'])->name('admin.registrasi.edit');
        Route::put('registrasi/{registrasi}', [RegistrasiPesertaController::class, 'update'])->name('admin.registrasi.update');
        Route::delete('registrasi/{registrasi}', [RegistrasiPesertaController::class, 'destroy'])->name('admin.registrasi.destroy');

        // =========================
        // KEUANGAN
        // =========================
        Route::prefix('keuangan')->group(function () {

            // SPD
            Route::get('spd', [SpdRincianController::class, 'index'])->name('admin.keuangan.spd.index');
            Route::get('spd/create', [SpdRincianController::class, 'create'])->name('admin.keuangan.spd.create');
            Route::get('spd/download-all', [SpdRincianController::class, 'downloadAll'])->name('admin.keuangan.spd.downloadAll');
            Route::get('spd/download-excel', [SpdRincianController::class, 'downloadExcel'])->name('admin.keuangan.spd.download-excel');
            Route::post('spd', [SpdRincianController::class, 'store'])->name('admin.keuangan.spd.store');
            Route::get('spd/{spd}', [SpdRincianController::class, 'show'])->name('admin.keuangan.spd.show');
            Route::get('spd/{spd}/print', [SpdRincianController::class, 'print'])->name('admin.keuangan.spd.print');
            Route::get('spd/{spd}/download', [SpdRincianController::class, 'download'])->name('admin.keuangan.spd.download');
            Route::delete('spd/{spd}', [SpdRincianController::class, 'destroy'])->name('admin.keuangan.spd.destroy');
            Route::post('/spd/import', [SpdRincianController::class, 'import'])->name('admin.keuangan.spd.import');
            Route::get('spd/{spd}/edit', [SpdRincianController::class, 'edit'])->name('admin.keuangan.spd.edit');
            Route::put('spd/{spd}', [SpdRincianController::class, 'update'])->name('admin.keuangan.spd.update');


            // KUITANSI
            Route::get('kuitansi', [KuitansiController::class, 'index'])->name('admin.keuangan.kuitansi.index');
            Route::get('kuitansi/create', [KuitansiController::class, 'create'])->name('admin.keuangan.kuitansi.create');
            Route::get('kuitansi/download-all', [KuitansiController::class, 'downloadAll'])->name('admin.keuangan.kuitansi.downloadAll');
            Route::post('kuitansi', [KuitansiController::class, 'store'])->name('admin.keuangan.kuitansi.store');
            Route::get('kuitansi/{kuitansi}', [KuitansiController::class, 'show'])->name('admin.keuangan.kuitansi.show');
            Route::get('kuitansi/{kuitansi}/print', [KuitansiController::class, 'print'])->name('admin.keuangan.kuitansi.print');
            Route::get('kuitansi/{kuitansi}/download', [KuitansiController::class, 'download'])->name('admin.keuangan.kuitansi.download');
            Route::get('kuitansi/{kuitansi}/edit', [KuitansiController::class, 'edit'])->name('admin.keuangan.kuitansi.edit');
            Route::put('kuitansi/{kuitansi}', [KuitansiController::class, 'update'])->name('admin.keuangan.kuitansi.update');
            Route::delete('kuitansi/{kuitansi}', [KuitansiController::class, 'destroy'])->name('admin.keuangan.kuitansi.destroy');
        });
    });

    // ================= FASILITATOR =================
    Route::middleware('role:fasil')->prefix('fasil')->group(function () {
        Route::get('dashboard', [FasilDashboardController::class, 'index'])->name('fasil.dashboard');
    });
});
