

<?php $__env->startSection('page_title','Daftar Hadir Narasumber'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
            Daftar Hadir Narasumber<br>
            <small class="text-muted">
                <?php echo e($daftarHadir->suratTugas->nama_kegiatan); ?>

            </small>
        </h5>

        <a href="<?php echo e(route('daftar-hadir-narasumber.create', $daftarHadir->id)); ?>"
           class="btn btn-success btn-sm">
            <i class="bi bi-plus-circle"></i> Tambah Narasumber
        </a>
    </div>

    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead class="table-light">
                <tr>
                    <th width="40">No</th>
                    <th>Nama Narasumber</th>
                    <th width="160">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $daftarHadir->detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($i + 1); ?></td>
                    <td><?php echo e($row->nama_manual); ?></td>
                    <td class="text-center">
                        <div class="btn-group btn-group-sm">
                            <a href="<?php echo e(route('daftar-hadir-narasumber.edit', $daftarHadir->id)); ?>"
                               class="btn btn-warning">
                                <i class="bi bi-pencil-square"></i>
                            </a>

                            <form action="<?php echo e(route('daftar-hadir-narasumber.destroy', $daftarHadir->id)); ?>"
                                  method="POST"
                                  onsubmit="return confirm('Yakin hapus semua narasumber?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="3" class="text-center text-muted">
                        Belum ada narasumber
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div class="mt-3">
            <a href="<?php echo e(route('daftar-hadir.index')); ?>"
               class="btn btn-secondary btn-sm">
                Kembali
            </a>

            <a href="<?php echo e(route('daftar-hadir-narasumber.cetak', $daftarHadir->id)); ?>"
               target="_blank"
               class="btn btn-primary btn-sm">
                <i class="bi bi-printer"></i> Cetak
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/kegiatan/daftar-hadir/narasumber.blade.php ENDPATH**/ ?>