

<?php $__env->startSection('page_title', 'Buat Surat Tugas'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('surat-tugas.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            
            <div class="mb-3">
                <label class="form-label fw-semibold">Nama Kegiatan</label>
                <input type="text"
                       name="nama_kegiatan"
                       class="form-control"
                       value="<?php echo e(old('nama_kegiatan')); ?>"
                       required
                       placeholder="Contoh: Pendampingan Akreditasi Prodi">
            </div>

            
            <div class="mb-3">
                <label class="form-label">Nomor Surat Tugas</label>
                <input type="text"
                       name="nomor_surat"
                       class="form-control"
                       value="<?php echo e(old('nomor_surat')); ?>"
                       required>
            </div>

            
            <div class="mb-3">
                <label class="form-label">Tanggal Surat</label>
                <input type="date"
                       name="tanggal_surat"
                       class="form-control"
                       value="<?php echo e(old('tanggal_surat')); ?>"
                       required>
            </div>

            
            <div class="mb-4">
                <label class="form-label">Tempat Kegiatan</label>
                <input type="text"
                       name="tempat"
                       class="form-control"
                       value="<?php echo e(old('tempat')); ?>"
                       placeholder="Contoh: Hotel Mercure Jakarta"
                       required>
            </div>

            <hr>

            
            <div class="mb-3">
                <label class="form-label">Pejabat Penandatangan</label>
                <input type="text"
                       name="pejabat_penandatangan"
                       class="form-control"
                       value="<?php echo e(old('pejabat_penandatangan')); ?>"
                       required>
            </div>

            
            <div class="mb-3">
                <label class="form-label">NIP Penandatangan</label>
                <input type="text"
                       name="nip_penandatangan"
                       class="form-control"
                       value="<?php echo e(old('nip_penandatangan')); ?>">
            </div>

            
            <div class="mb-4">
                <label class="form-label">Jabatan Penandatangan</label>
                <input type="text"
                       name="jabatan_penandatangan"
                       class="form-control"
                       value="<?php echo e(old('jabatan_penandatangan')); ?>"
                       required>
            </div>

            <hr>

            
            <div class="mb-3">
                <label class="form-label fw-semibold">Pegawai yang Ditugaskan</label>

                <div class="card">
                    <div class="card-body" style="max-height: 350px; overflow-y: auto">

                        <?php $__empty_1 = true; $__currentLoopData = $pegawais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jabatan => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $groupClass = \Illuminate\Support\Str::slug($jabatan ?? 'tanpa-jabatan');
                            ?>

                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <strong><?php echo e($jabatan ?? 'Tanpa Jabatan'); ?></strong>

                                    <div class="form-check">
                                        <input type="checkbox"
                                               class="form-check-input select-all"
                                               data-group="<?php echo e($groupClass); ?>"
                                               id="select-all-<?php echo e($groupClass); ?>">
                                        <label class="form-check-label small"
                                               for="select-all-<?php echo e($groupClass); ?>">
                                            Pilih Semua
                                        </label>
                                    </div>
                                </div>

                                <hr class="my-2">

                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pegawai): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check ms-3 mb-1">
                                        <input class="form-check-input pegawai-checkbox <?php echo e($groupClass); ?>"
                                               type="checkbox"
                                               name="pegawai_ids[]"
                                               value="<?php echo e($pegawai->id); ?>"
                                               id="pegawai-<?php echo e($pegawai->id); ?>"
                                               <?php echo e(in_array($pegawai->id, old('pegawai_ids', [])) ? 'checked' : ''); ?>>

                                        <label class="form-check-label"
                                               for="pegawai-<?php echo e($pegawai->id); ?>">
                                            <?php echo e($pegawai->nama); ?>

                                            <small class="text-muted">
                                                (<?php echo e($pegawai->nip ?? '-'); ?>)
                                            </small>
                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-muted mb-0">
                                Data pegawai belum tersedia.
                            </p>
                        <?php endif; ?>

                    </div>
                </div>
            </div>

            
            <div class="mt-4">
                <button type="submit" class="btn btn-success">
                    Simpan Surat Tugas
                </button>
                <a href="<?php echo e(route('surat-tugas.index')); ?>" class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.querySelectorAll('.select-all').forEach(function (checkbox) {
        checkbox.addEventListener('change', function () {
            const group = this.dataset.group;
            document.querySelectorAll('.' + group).forEach(function (item) {
                item.checked = checkbox.checked;
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/kegiatan/surat-tugas/create.blade.php ENDPATH**/ ?>