

<?php $__env->startSection('page_title','Edit Surat Tugas'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('surat-tugas.update', $surat->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            
            <div class="mb-3">
                <label class="form-label fw-semibold">Nama Kegiatan</label>
                <input type="text"
                       name="nama_kegiatan"
                       class="form-control"
                       value="<?php echo e(old('nama_kegiatan', $surat->nama_kegiatan)); ?>"
                       required>
            </div>

            
            <div class="mb-3">
                <label class="form-label">Nomor Surat Tugas</label>
                <input type="text"
                       name="nomor_surat"
                       class="form-control"
                       value="<?php echo e(old('nomor_surat', $surat->nomor_surat)); ?>"
                       required>
            </div>

            
            <div class="mb-3">
                <label class="form-label">Tanggal Surat</label>
                <input type="date"
                       name="tanggal_surat"
                       class="form-control"
                       value="<?php echo e(old('tanggal_surat', $surat->tanggal_surat)); ?>"
                       required>
            </div>

            
            <div class="mb-4">
                <label class="form-label">Tempat Kegiatan</label>
                <input type="text"
                       name="tempat"
                       class="form-control"
                       value="<?php echo e(old('tempat', $surat->tempat)); ?>"
                       placeholder="Contoh: Hotel Mercure Jakarta"
                       required>
            </div>

            <hr>

            
            <div class="mb-3">
                <label class="form-label">Pejabat Penandatangan</label>
                <input type="text"
                       name="pejabat_penandatangan"
                       class="form-control"
                       value="<?php echo e(old('pejabat_penandatangan', $surat->pejabat_penandatangan)); ?>"
                       required>
            </div>

            
            <div class="mb-3">
                <label class="form-label">NIP Penandatangan</label>
                <input type="text"
                       name="nip_penandatangan"
                       class="form-control"
                       value="<?php echo e(old('nip_penandatangan', $surat->nip_penandatangan)); ?>">
            </div>

            
            <div class="mb-4">
                <label class="form-label">Jabatan Penandatangan</label>
                <input type="text"
                       name="jabatan_penandatangan"
                       class="form-control"
                       value="<?php echo e(old('jabatan_penandatangan', $surat->jabatan_penandatangan)); ?>"
                       required>
            </div>

            <hr>

            
            <div class="mb-3">
                <label class="form-label fw-semibold">Pegawai yang Ditugaskan</label>

                <div class="card">
                    <div class="card-body" style="max-height:350px; overflow-y:auto">

                        <?php $__currentLoopData = $pegawais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jabatan => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $groupClass = \Illuminate\Support\Str::slug($jabatan ?? 'tanpa-jabatan');
                            ?>

                            <div class="mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <strong><?php echo e($jabatan ?? 'Tanpa Jabatan'); ?></strong>

                                    <div class="form-check">
                                        <input type="checkbox"
                                               class="form-check-input select-all"
                                               data-group="<?php echo e($groupClass); ?>"
                                               id="select-all-<?php echo e($groupClass); ?>">
                                        <label class="form-check-label small"
                                               for="select-all-<?php echo e($groupClass); ?>">
                                            Pilih Semua
                                        </label>
                                    </div>
                                </div>

                                <hr class="my-2">

                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pegawai): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check ms-3 mb-1">
                                        <input class="form-check-input pegawai-checkbox <?php echo e($groupClass); ?>"
                                               type="checkbox"
                                               name="pegawai_ids[]"
                                               value="<?php echo e($pegawai->id); ?>"
                                               id="pegawai-<?php echo e($pegawai->id); ?>"
                                               <?php echo e(in_array($pegawai->id, $selectedPegawai) ? 'checked' : ''); ?>>

                                        <label class="form-check-label"
                                               for="pegawai-<?php echo e($pegawai->id); ?>">
                                            <?php echo e($pegawai->nama); ?>

                                            <small class="text-muted">
                                                (<?php echo e($pegawai->nip ?? '-'); ?>)
                                            </small>
                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>

            
            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    Update Surat Tugas
                </button>
                <a href="<?php echo e(route('surat-tugas.index')); ?>" class="btn btn-secondary">
                    Kembali
                </a>
            </div>

        </form>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Pilih semua per jabatan
    document.querySelectorAll('.select-all').forEach(function (checkbox) {
        checkbox.addEventListener('change', function () {
            const group = this.dataset.group;
            document.querySelectorAll('.' + group).forEach(function (item) {
                item.checked = checkbox.checked;
            });
        });
    });

    // Auto-centang "Pilih Semua" jika semua pegawai terpilih
    document.querySelectorAll('.select-all').forEach(function (selectAll) {
        const group = selectAll.dataset.group;
        const items = document.querySelectorAll('.' + group);
        selectAll.checked = [...items].every(cb => cb.checked);
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/kegiatan/surat-tugas/edit.blade.php ENDPATH**/ ?>