

<?php $__env->startSection('content'); ?>
<div class="container py-3">
  <div class="d-flex flex-wrap justify-content-between align-items-center gap-2 mb-3">
    <div>
      <h4 class="mb-0">Laporan Kegiatan & Daftar Hadir</h4>
      <div class="text-muted small">
        Pilih jadwal kegiatan, lalu unduh dokumen: <b>Laporan</b>, <b>Absensi Peserta</b>, atau <b>Absensi Fasil</b>.
      </div>
    </div>
  </div>

  <?php $__empty_1 = true; $__currentLoopData = $pelatihan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="card mb-3 shadow-sm">
      <div class="card-header fw-bold d-flex justify-content-between align-items-center">
        <span><?php echo e($p->nama_pelatihan); ?></span>
        <span class="badge text-bg-light border">
          Kelas: <?php echo e($p->kelas->count()); ?>

        </span>
      </div>

      <div class="card-body">
        <?php $__empty_2 = true; $__currentLoopData = $p->kelas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
          <div class="border rounded-3 p-3 mb-3">
            <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
              <div>
                <div class="fw-bold"><?php echo e($k->nama_kelas); ?></div>
                <div class="text-muted small">
                  Jumlah jadwal: <b><?php echo e($k->jadwal->count()); ?></b>
                </div>
                <a href="<?php echo e(route('admin.kelas.jadwal.create', $k->id)); ?>" class="btn btn-sm btn-primary">
                  + Tambah Jadwal
                </a>
              </div>

              <?php if($k->jadwal->count() > 0): ?>
                <div class="text-muted small">
                  Klik tombol di kolom <b>Dokumen</b> sesuai kebutuhan.
                </div>
              <?php endif; ?>
            </div>

            <div class="table-responsive mt-3">
              <table class="table table-sm align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th style="width:140px;">Tanggal</th>
                    <th style="width:160px;">Jam</th>
                    <th>Tempat</th>
                    <th class="text-end" style="width:360px;">Dokumen</th>
                  </tr>
                </thead>

                <tbody>
                <?php $__empty_3 = true; $__currentLoopData = $k->jadwal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_3 = false; ?>
                  <tr>
                    <td>
                      <?php echo e(\Carbon\Carbon::parse($j->tanggal)->format('d-m-Y')); ?>

                      <div class="text-muted small">
                        <?php echo e(\Carbon\Carbon::parse($j->tanggal)->translatedFormat('l')); ?>

                      </div>
                    </td>
                    <td>
                      <?php echo e(substr($j->jam_mulai,0,5)); ?> - <?php echo e(substr($j->jam_selesai,0,5)); ?>

                      <?php if(!empty($j->ishoma_mulai) && !empty($j->ishoma_selesai)): ?>
                        <div class="text-muted small">
                          Ishoma: <?php echo e(substr($j->ishoma_mulai,0,5)); ?>-<?php echo e(substr($j->ishoma_selesai,0,5)); ?>

                        </div>
                      <?php endif; ?>
                    </td>
                    <td><?php echo e($j->tempat ?? '-'); ?></td>
                    <td class="text-end">
                      <div class="d-flex justify-content-end flex-wrap gap-2">
                        <a class="btn btn-outline-primary btn-sm"
                           href="<?php echo e(route('admin.laporan-kegiatan.downloadLaporan', $j->id)); ?>">
                          <i class="bi bi-file-earmark-text me-1"></i>Laporan (.doc)
                        </a>

                        <a class="btn btn-outline-success btn-sm"
                           href="<?php echo e(route('admin.laporan-kegiatan.downloadDaftarHadirPeserta', $j->id)); ?>">
                          <i class="bi bi-people me-1"></i>Absensi Peserta
                        </a>

                        <a class="btn btn-outline-dark btn-sm"
                           href="<?php echo e(route('admin.laporan-kegiatan.downloadDaftarHadirFasil', $j->id)); ?>">
                          <i class="bi bi-person-badge me-1"></i>Absensi Fasil
                        </a>
                      </div>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_3): ?>
                  <tr>
                    <td colspan="4" class="text-muted text-center py-3">
                      Belum ada jadwal untuk kelas ini.
                    </td>
                  </tr>
                <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
          <div class="text-muted">Belum ada kelas untuk pelatihan ini.</div>
        <?php endif; ?>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="alert alert-light border">
      Belum ada data pelatihan.
    </div>
  <?php endif; ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Gilang\BGTK\bgtk-dashboard\resources\views/admin/laporan_kegiatan/index.blade.php ENDPATH**/ ?>